/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.server.impl;

import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.reportmeta.sumreport.data.LogInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SnapDataBean;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.SnapshotDataException;
import com.kingdee.eas.base.reportmeta.sumreport.server.ISnapshotBOFacade;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SnapshotBOFacade
implements ISnapshotBOFacade {
    public void delete(String id) throws SnapshotDataException {
        String sql = "delete from T_EXT_SNAPSHOTDATA where id = ?";
        try {
            DbUtil.executeUpdate((String)sql, (Object[])new Object[]{id});
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u5220\u9664\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    public void insert(String id, SnapDataBean[] entitys) throws SnapshotDataException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(entitys.length * 4);
            int len = entitys.length;
            for (int i = 0; i < len; ++i) {
                params.add(id);
                params.add(new Integer(i));
                params.add(entitys[i].getBlock());
                params.add(new Integer(entitys[i].getSize()));
            }
            String sql = "insert into T_EXT_SNAPSHOTDATA(fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
            DbUtil.executeBatchUpdate((String)sql, params, (int)4, null);
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u4fdd\u5b58\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    public byte[] queryEntity(String id) throws SnapshotDataException {
        String sql = "select fblockIndex,fcontent,flength from T_EXT_SNAPSHOTDATA where fid =? order by FID,FBlockIndex";
        try {
            IRowSet rs = DbUtil.executeQuery((String)sql, (Object[])new Object[]{id});
            SnapDataBean[] beans = new SnapDataBean[rs.size()];
            int index = 0;
            while (rs.next()) {
                InputStream in = rs.getBlob("fcontent").getBinaryStream();
                int length = rs.getInt("flength");
                byte[] block = new byte[length];
                try {
                    in.read(block);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                beans[index++] = new SnapDataBean(block, length);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < beans.length; ++i) {
                out.write(beans[i].getBlock(), 0, beans[i].getSize());
                beans[i].GCBlock();
            }
            return out.toByteArray();
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u67e5\u8be2\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    public void update(String id, SnapDataBean[] entitys) throws SnapshotDataException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(entitys.length * 4);
            int len = entitys.length;
            for (int i = 0; i < len; ++i) {
                params.add(id);
                params.add(new Integer(i));
                params.add(entitys[i].getBlock());
                params.add(new Integer(entitys[i].getSize()));
            }
            String sql = "insert into T_EXT_SNAPSHOTDATA(fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
            StringBuffer delSql = new StringBuffer("delete from T_EXT_SNAPSHOTDATA where fid ='");
            delSql.append(id).append('\'');
            DbUtil.executeBatchUpdate((String)sql, params, (int)4, (String)delSql.toString());
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u4fdd\u5b58\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    public IORMModel queryInterface(Class arg0) throws ORMCoreException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public void batchDel(List ids) throws SnapshotDataException {
        String sql = "delete from T_EXT_SNAPSHOTDATA where fid = ?";
        try {
            DbUtil.executeBatchUpdate((String)sql, (List)ids, (int)1, null);
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u5220\u9664\u5feb\u7167\u5931\u8d25\uff01", e);
        }
    }

    public void deleteLog(String activityID) throws SnapshotDataException {
        String sql = " delete from t_ext_log where FACTIVITYID = ?";
        try {
            DbUtil.executeUpdate((String)sql, (Object[])new Object[]{activityID});
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u5220\u9664\u65e5\u5fd7\u5931\u8d25\uff01", e);
        }
    }

    public void insertLog(LogInfo log) throws SnapshotDataException {
        String sql = "insert into t_ext_log(fid,feditor,fedittime,factivityid,fremark)values(?,?,?,?,?)";
        Timestamp now = new Timestamp(new Date().getTime());
        try {
            DbUtil.executeUpdate((String)sql, (Object[])new Object[]{log.getId(), log.getEditor(), now, log.getActivityID(), log.getRemark()});
        }
        catch (SQLException e) {
            throw SnapshotDataException.wrap("\u63d2\u5165\u65e5\u5fd7\u5931\u8d25\uff01", e);
        }
    }

    public List queryLog(String activityID) throws SnapshotDataException {
        LinkedList<LogInfo> linkedList;
        String sql = "select feditor as editor,fedittime as edittime,fremark as remark from t_ext_log where factivityid = ? order by fedittime desc ";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sql, (Object[])new Object[]{activityID});
            LinkedList<LogInfo> ls = new LinkedList<LogInfo>();
            while (rs.next()) {
                LogInfo log = new LogInfo();
                log.setEditor(rs.getString("editor"));
                log.setEditTime(rs.getTimestamp("edittime"));
                log.setRemark(rs.getString("remark"));
                ls.add(log);
            }
            linkedList = ls;
        }
        catch (SQLException e) {
            try {
                throw SnapshotDataException.wrap("\u67e5\u8be2\u65e5\u5fd7\u5931\u8d25\uff01", e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return linkedList;
    }

    public String getSnapPK(String activityID) throws SnapshotDataException {
        String string;
        String sql = "select fid from T_RM_ReportSnap where FTaskDetailID = ?";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sql, (Object[])new Object[]{activityID});
            String snapID = null;
            while (rs.next()) {
                snapID = rs.getString("fid");
            }
            string = snapID;
        }
        catch (SQLException e) {
            try {
                throw SnapshotDataException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return string;
    }

    public Map queryEntitys(Object[] snapIDs) throws SnapshotDataException {
        HashMap<String, byte[]> hashMap;
        StringBuffer sqlBuf = new StringBuffer("select s.FTaskDetailID ,c.fblockIndex,c.fContent,c.flength from T_EXT_SNAPSHOTDATA c left outer join T_RM_ReportSnap  s on c.fid =s.fid  where s.FTaskDetailID in (");
        for (int i = 0; i < snapIDs.length; ++i) {
            String snapID = (String)snapIDs[i];
            sqlBuf.append('\'').append(snapID).append("',");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        sqlBuf.append(" order by s.ftaskdetailid asc, c.fblockIndex desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), null);
            HashMap<String, byte[]> rsMap = new HashMap<String, byte[]>(rs.size());
            if (rs.next()) {
                boolean breakAll = false;
                do {
                    String id = rs.getString("FTaskDetailID");
                    int size = rs.getInt("fblockIndex") + 1;
                    SnapDataBean[] beans = new SnapDataBean[size];
                    int index = 0;
                    for (int i = size - 1; i >= 0; --i) {
                        InputStream in = rs.getBlob("fcontent").getBinaryStream();
                        int length = rs.getInt("flength");
                        byte[] block = new byte[length];
                        try {
                            in.read(block);
                        }
                        catch (IOException e) {
                            throw SnapshotDataException.wrap(e);
                        }
                        beans[index++] = new SnapDataBean(block, length);
                        if (rs.next()) continue;
                        breakAll = true;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    for (int i = beans.length - 1; i >= 0; --i) {
                        out.write(beans[i].getBlock(), 0, beans[i].getSize());
                        beans[i].GCBlock();
                    }
                    rsMap.put(id, out.toByteArray());
                } while (!breakAll);
            }
            hashMap = rsMap;
        }
        catch (SQLException e) {
            try {
                throw SnapshotDataException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    public String[] determineAcivitiesState(Object[] activityIDS) throws SnapshotDataException {
        String[] stringArray;
        if (activityIDS == null || activityIDS.length == 0) {
            return null;
        }
        StringBuffer sqlBuf = new StringBuffer("select fid from T_EXT_TaskDetail where FState <3 and fid in(");
        for (int i = 0; i < activityIDS.length; ++i) {
            String snapID = (String)activityIDS[i];
            sqlBuf.append('\'').append(snapID).append("',");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), null);
            String[] rsArray = new String[rs.size()];
            int idx = 0;
            while (rs.next()) {
                rsArray[idx++] = rs.getString("fid");
            }
            stringArray = rsArray;
        }
        catch (SQLException e) {
            try {
                throw SnapshotDataException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return stringArray;
    }

    public String[] getSnapPKs(Object[] activitiesID) throws SnapshotDataException {
        String[] stringArray;
        if (activitiesID == null || activitiesID.length == 0) {
            return null;
        }
        StringBuffer sqlBuf = new StringBuffer("select fid from T_RM_ReportSnap where FTaskDetailID in (");
        for (int i = 0; i < activitiesID.length; ++i) {
            String activityID = (String)activitiesID[i];
            sqlBuf.append('\'').append(activityID).append("',");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), null);
            String[] rsArray = new String[rs.size()];
            int idx = 0;
            while (rs.next()) {
                rsArray[idx++] = rs.getString("fid");
            }
            stringArray = rsArray;
        }
        catch (SQLException e) {
            try {
                throw SnapshotDataException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return stringArray;
    }
}

