/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import java.util.Calendar;

class DateProcesser
implements AbstractEngine.IDataProcesser,
FilterPreparedValueGainer.IDateReprocessing {
    private AnalyticalField _field;

    public DateProcesser(AnalyticalField field) {
        this._field = field;
    }

    @Override
    public Calendar process(Object value) {
        if (value instanceof Calendar) {
            return this.process((Calendar)value);
        }
        return null;
    }

    private Calendar process(Calendar calendar) {
        if (calendar != null && this._field.getPartValue() != null) {
            if (this._field.isContinuous()) {
                switch (this._field.getPartValue()) {
                    case DATE_YEAR: {
                        return this.getYear(calendar);
                    }
                    case DATE_QUARTER: 
                    case DATE_YQ: {
                        return this.getYQ(calendar);
                    }
                    case DATE_MONTH: 
                    case DATE_YM: {
                        return this.getYM(calendar);
                    }
                }
                return this.getYMD(calendar);
            }
            switch (this._field.getPartValue()) {
                case DATE_YEAR: {
                    return this.getFiscalableYear(calendar);
                }
                case DATE_QUARTER: {
                    return this.getFiscalableQuarter(calendar);
                }
                case DATE_MONTH: {
                    return this.getFiscalableMonth(calendar);
                }
                case DATE_DAY: {
                    return this.getDayAtMonth(calendar);
                }
                case DATE_YQ: {
                    return this.getYQ(calendar);
                }
                case DATE_YM: {
                    return this.getYM(calendar);
                }
                case DATE_YMD: {
                    return this.getYMD(calendar);
                }
            }
        }
        return calendar;
    }

    private int getFiscalYearStart() {
        int fys = this._field.getFiscalYearStart();
        return fys > 1 && fys < 13 ? fys : 1;
    }

    private Calendar createCalendar(int year, int month, int day) {
        Calendar inst = Calendar.getInstance();
        inst.set(year, month - 1, day, 0, 0, 0);
        inst.set(14, 0);
        return inst;
    }

    private int monthForQuarter(int month) {
        return (month - 1) / 3 * 3 + 1;
    }

    private Calendar getFiscalableYear(Calendar calendar) {
        int month;
        int year = calendar.get(1);
        int fystart = this.getFiscalYearStart();
        if (fystart > 1 && (month = calendar.get(2) + 1) >= fystart) {
            ++year;
        }
        return this.createCalendar(year, 1, 1);
    }

    private Calendar getFiscalableQuarter(Calendar calendar) {
        int year = 2018;
        int month = calendar.get(2) + 1;
        int fystart = this.getFiscalYearStart();
        int monthAtFY = fystart > 1 ? (month - fystart + 12) % 12 + 1 : month;
        int monthForQuarter = this.monthForQuarter(monthAtFY);
        return this.createCalendar(year, monthForQuarter, 1);
    }

    private Calendar getFiscalableMonth(Calendar calendar) {
        int year = 2016;
        int month = calendar.get(2) + 1;
        int fystart = this.getFiscalYearStart();
        if (fystart > 1 && month >= fystart) {
            --year;
        }
        return this.createCalendar(year, month, 1);
    }

    private Calendar getDayAtMonth(Calendar calendar) {
        int year = 2018;
        int month = 1;
        int day = calendar.get(5);
        return this.createCalendar(year, month, day);
    }

    private Calendar getYear(Calendar calendar) {
        int year = calendar.get(1);
        return this.createCalendar(year, 1, 1);
    }

    private Calendar getYQ(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int monthForQuarter = this.monthForQuarter(month);
        return this.createCalendar(year, monthForQuarter, 1);
    }

    private Calendar getYM(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        return this.createCalendar(year, month, 1);
    }

    private Calendar getYMD(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return this.createCalendar(year, month, day);
    }

    @Override
    public String toPromissoryValue(Object preparedValue) {
        Calendar calendar = (Calendar)preparedValue;
        switch (this._field.getPartValue()) {
            case DATE_YEAR: {
                return this.formatPromissoryY(calendar);
            }
            case DATE_QUARTER: {
                return this.formatPromissoryQ(calendar);
            }
            case DATE_MONTH: {
                return this.formatPromissoryM(calendar);
            }
            case DATE_DAY: {
                return this.formatPromissoryD(calendar);
            }
            case DATE_YQ: {
                return this.formatPromissoryYQ(calendar);
            }
            case DATE_YM: {
                return this.formatPromissoryYM(calendar);
            }
            case DATE_YMD: {
                return this.formatPromissoryYMD(calendar);
            }
        }
        return Long.toString(calendar.getTimeInMillis());
    }

    private String formatPromissoryY(Calendar calendar) {
        int y = calendar.get(1);
        return Integer.toString(y);
    }

    private String formatPromissoryQ(Calendar calendar) {
        int m = calendar.get(2);
        int q = m / 3 + 1;
        return Integer.toString(q);
    }

    private String formatPromissoryM(Calendar calendar) {
        int m = calendar.get(2);
        return Integer.toString(m);
    }

    private String formatPromissoryD(Calendar calendar) {
        int d = calendar.get(5);
        return Integer.toString(d);
    }

    private String formatPromissoryYQ(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2);
        int q = m / 3 + 1;
        return Integer.toString(y) + this.formatTwoChar(q);
    }

    private String formatPromissoryYM(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2);
        return Integer.toString(y) + this.formatTwoChar(m);
    }

    private String formatPromissoryYMD(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2);
        int d = calendar.get(5);
        return Integer.toString(y) + this.formatTwoChar(m) + this.formatTwoChar(d);
    }

    private String formatTwoChar(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }
}

