/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.core.model.meta.ParentChildDimension;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParentChildDimensionFilterPretreater {
    private Set<String> _fieldFullNames = new HashSet<String>();
    private List<Handler> _handlers = new ArrayList<Handler>();

    public void pretreat(AbstractQingModel model, List<AnalyticalField> dimensionFields, IDataSourceVisitor dataSourceVisitor) throws AnalysisException {
        final HashSet<String> dimensions = new HashSet<String>();
        for (AnalyticalField field : dimensionFields) {
            dimensions.add(field.getMetaField().getFullName());
        }
        model.visitFilters(new AbstractQingModel.IFilterVisitor(){

            @Override
            public void visit(AnalyticalField field, AbstractAnalyticalFilter filter) {
                MetaField mf = field.getMetaField();
                String groupName = mf.getGroupName();
                if (groupName != null && "discrete".equals(filter.getName())) {
                    DiscreteFilter discreteFilter = (DiscreteFilter)filter;
                    MetaTable mt = mf.getMetaTable();
                    ParentChildDimension pcd = mt.searchParentChildDimension(groupName);
                    if (pcd != null && !dimensions.contains(mf.getFullName())) {
                        ParentChildDimensionFilterPretreater.this.append(mt.getName(), pcd.getIdFieldName(), pcd.getParentIdFieldName(), discreteFilter);
                    }
                }
            }
        });
        this.pretreat(dataSourceVisitor);
    }

    private void append(String metaTableName, String idFieldPureName, String parentIdFieldPureName, DiscreteFilter filter) {
        String idField = MetaField.encodeFullName(metaTableName, idFieldPureName);
        String parentIdField = MetaField.encodeFullName(metaTableName, parentIdFieldPureName);
        this._fieldFullNames.add(idField);
        this._fieldFullNames.add(parentIdField);
        Handler handler = new Handler(idField, parentIdField, filter);
        this._handlers.add(handler);
    }

    private void pretreat(IDataSourceVisitor dataSourceVisitor) throws AnalysisException {
        DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(dataSourceVisitor);
        try {
            greenChannel.getDistinctValue(this._fieldFullNames, new DataSourceGreenChannel.AbstractValueCollecter(){

                @Override
                public void accept(Map<String, Object> values) {
                    for (Handler handler : ParentChildDimensionFilterPretreater.this._handlers) {
                        handler.collect(values);
                    }
                }
            });
        }
        catch (UserStoppedException ex) {
            throw ex;
        }
        catch (DataSourceNoDataException ex) {
            return;
        }
        catch (AbstractDataSourceException ex) {
            throw DataTraversalException.createGetDistinctError((Exception)((Object)ex));
        }
        for (Handler handler : this._handlers) {
            handler.cut();
        }
    }

    private static class Handler {
        private String _idField;
        private String _parentIdField;
        Map<String, String> _parentSearcher = new HashMap<String, String>();
        private DiscreteFilter _filter;

        public Handler(String idField, String parentIdField, DiscreteFilter filter) {
            this._idField = idField;
            this._parentIdField = parentIdField;
            this._filter = filter;
        }

        public void collect(Map<String, Object> values) {
            Object idValue = values.get(this._idField);
            Object parentIdValue = values.get(this._parentIdField);
            String id = idValue == null ? null : idValue.toString();
            String parentId = parentIdValue == null ? null : parentIdValue.toString();
            this._parentSearcher.put(id, parentId);
        }

        public void cut() {
            ArrayList<String> shortSelecteds = new ArrayList<String>();
            if (this._filter.isFullValue()) {
                this.pickRootItems(shortSelecteds);
                this._filter.setFullValue(false);
            } else {
                List<String> selecteds = this._filter.getSelecteds();
                this.deleteBeIncludedItems(selecteds, shortSelecteds);
            }
            this._filter.setSelecteds(shortSelecteds);
        }

        private void pickRootItems(List<String> shortSelecteds) {
            for (Map.Entry<String, String> pair : this._parentSearcher.entrySet()) {
                String parentIdValue = pair.getValue();
                if (parentIdValue != null) continue;
                String idValue = pair.getKey();
                shortSelecteds.add(idValue);
            }
        }

        private void deleteBeIncludedItems(List<String> selecteds, List<String> shortSelecteds) {
            HashSet<String> allSelecteds = new HashSet<String>();
            for (String idValue : selecteds) {
                allSelecteds.add(idValue);
            }
            for (String idValue : selecteds) {
                if (this.isAncestorSelected(idValue, allSelecteds)) continue;
                shortSelecteds.add(idValue);
            }
        }

        private boolean isAncestorSelected(String idValue, Set<String> allSelecteds) {
            String searching = idValue;
            for (int endlessPreventor = 0; searching != null && endlessPreventor < 20; ++endlessPreventor) {
                if ((searching = this._parentSearcher.get(searching)) == null || !allSelecteds.contains(searching)) continue;
                return true;
            }
            return false;
        }
    }
}

