/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.flattening.square.AbstractSimilarColumnMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.AbstractProgress;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.sub.Sort;
import java.math.BigDecimal;
import java.util.ArrayList;

abstract class AbstractProgressMaker
extends AbstractSimilarColumnMaker {
    AbstractProgressMaker() {
    }

    private AbstractProgress getDesignChartModel() {
        return (AbstractProgress)this.getModel().getChartModel();
    }

    @Override
    protected final FieldSet getCategoryAxis() {
        return this.getDesignChartModel().getDimension();
    }

    @Override
    protected final FieldSet getPrimaryAxis() {
        FieldSet desiredSet = this.getDesignChartModel().getDesired();
        FieldSet completedSet = this.getDesignChartModel().getCompleted();
        return this.mergeFieldSet(desiredSet, completedSet);
    }

    @Override
    protected final FieldSet getSeriesFieldSet() {
        return FieldSet.createEmptyInstance();
    }

    @Override
    protected final AbstractSimilarColumnMaker.AbstractScopeCollector createScopeCollector(int categoryCount) {
        return new AbstractSimilarColumnMaker.MultiSeriesScopeCollector(this);
    }

    protected final AbstractSimilarColumnMaker.AbstractColumnSortProcessor createProgressSortProcessorImpl(Sort sort) {
        boolean isAccordingDefault;
        Sort.SortAccording according = sort.getSortAccording();
        boolean bl = isAccordingDefault = according == null;
        if (isAccordingDefault) {
            AbstractSimilarColumnMaker.AbstractColumnSortProcessor sortProcessor = new AbstractSimilarColumnMaker.AbstractColumnSortProcessor(){

                @Override
                protected BigDecimal confirmAccordingValue(Aggregator[] aggregators) {
                    if (aggregators.length >= 2) {
                        BigDecimal desired = aggregators[0].getNumberValue();
                        BigDecimal completed = aggregators[1].getNumberValue();
                        if (completed != null && desired != null && desired.compareTo(BigDecimal.ZERO) != 0) {
                            int scale = Math.max(desired.scale(), completed.scale());
                            scale = Math.min(15, Math.max(8, scale));
                            return completed.divide(desired, scale, 4);
                        }
                    }
                    return null;
                }
            };
            sortProcessor.setAscendent(sort.isAscendent());
            sortProcessor.setTopN(sort.getTopN());
            sortProcessor.setOthersAsAnItem(sort.isOthersAsAnItem());
            return sortProcessor;
        }
        return super.createSortProcessorImpl(sort);
    }

    private FieldSet mergeFieldSet(FieldSet set1, FieldSet set2) {
        int i;
        FieldSet newSet = new FieldSet();
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>(set1.getFieldCount() + set2.getFieldCount());
        for (i = 0; i < set1.getFieldCount(); ++i) {
            fields.add(set1.getField(i));
        }
        for (i = 0; i < set2.getFieldCount(); ++i) {
            fields.add(set2.getField(i));
        }
        newSet.updateFields(fields);
        return newSet;
    }
}

