/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model;

import com.kingdee.bos.qing.core.model.ExecutingModelWrapper;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.brief.BriefOutputDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.AnalyticalPreferences;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.preferences.SquarePreperences;
import com.kingdee.bos.qing.core.model.meta.view.AbstractViewItem;
import com.kingdee.bos.qing.util.JsonUtil;

public class ModelJsonDecoder {
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();

    public static <T> T decode(String jsonString, Class<T> clz) {
        return (T)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, clz);
    }

    public static ModelBook decode(String jsonString) {
        ModelBook mb = (ModelBook)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, ModelBook.class);
        return mb;
    }

    public static ExecutingModelWrapper decodeForExecuting(String jsonString) {
        ExecutingModelWrapper mw = (ExecutingModelWrapper)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, ExecutingModelWrapper.class);
        ModelBook.ModelPage.prepareForExecuting(mw.getMeta(), mw.getModel(), mw.getPreferences());
        return mw;
    }

    static {
        customJsonParser.addCustomDecoder(AbstractViewItem.class, (JsonUtil.AbstractJsonDecoder)new AbstractViewItem.JsonDecoder());
        customJsonParser.addCustomDecoder(IQingModel.class, (JsonUtil.AbstractJsonDecoder)new QingModelJsonDecoder());
        customJsonParser.addCustomDecoder(IPreferences.class, (JsonUtil.AbstractJsonDecoder)new PreferencesJsonDecoder());
        customJsonParser.addCustomDecoder(AbstractAnalyticalFilter.class, (JsonUtil.AbstractJsonDecoder)new AbstractAnalyticalFilter.JsonDecoder());
        customJsonParser.addCustomDecoder(AbstractChart.class, (JsonUtil.AbstractJsonDecoder)new AbstractChart.JsonDecoder());
        customJsonParser.addCustomDecoder(AbstractChartProperty.class, (JsonUtil.AbstractJsonDecoder)new AbstractChartProperty.JsonDecoder());
        customJsonParser.addCustomDecoder(BriefOutputDefinition.AbstractPicker.class, (JsonUtil.AbstractJsonDecoder)new BriefOutputDefinition.JsonDecoder());
        customJsonParser.addCustomDecoder(WarningRuleDefinition.AbstractCondition.class, (JsonUtil.AbstractJsonDecoder)new WarningRuleDefinition.JsonDecoder());
    }

    private static class PreferencesJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<IPreferences> {
        private PreferencesJsonDecoder() {
        }

        protected IPreferences decode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("designerStatus") || json.hasAttr("exhibitionStatus") || json.hasAttr("chartConfig") || json.hasAttr("exportSetting")) {
                return (IPreferences)this.fromJson(json, AnalyticalPreferences.class);
            }
            if (json.hasAttr("previewSetup")) {
                return (IPreferences)this.fromJson(json, SquarePreperences.class);
            }
            return null;
        }
    }

    private static class QingModelJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<IQingModel> {
        private QingModelJsonDecoder() {
        }

        protected IQingModel decode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("chart")) {
                return (IQingModel)this.fromJson(json, SquareModel.class);
            }
            if (json.hasAttr("chartType")) {
                return (IQingModel)this.fromJson(json, AnalyticalModel.class);
            }
            throw new RuntimeException("Unknown IQingModel.");
        }
    }
}

