/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.meta.MetaField;

public enum QuickSetup {
    LP_V(MetaField.FormulaAggStatus.Interline, "LastPeriod(#Agg, \"value\")", "lastPeriodValue", "\u4e0a\u671f\u503c"),
    LP(MetaField.FormulaAggStatus.Interline, "LastPeriod(#Agg)", "lastPeriodRatio", "\u73af\u6bd4"),
    SPLY_V(MetaField.FormulaAggStatus.Interline, "SamePeriodLastYear(#Agg, \"value\")", "samePeriodLastYearValue", "\u53bb\u5e74\u540c\u671f\u503c"),
    SPLY(MetaField.FormulaAggStatus.Interline, "SamePeriodLastYear(#Agg)", "samePeriodLastYearRatio", "\u540c\u6bd4"),
    RS(MetaField.FormulaAggStatus.Interline, "RunningSum(#Agg)", "runningSum", "\u7d2f\u8ba1"),
    RSY(MetaField.FormulaAggStatus.Interline, "RunningSum(#Agg, \"Y\")", "runningSum", "\u7d2f\u8ba1"),
    RATIO_10(MetaField.FormulaAggStatus.WithTotal, "#Agg / Total(#Agg, 1, 0)", "ratio", "\u5360\u6bd4"),
    RATIO_01(MetaField.FormulaAggStatus.WithTotal, "#Agg / Total(#Agg, 0, 1)", "ratio", "\u5360\u6bd4"),
    RATIO_11(MetaField.FormulaAggStatus.WithTotal, "#Agg / Total(#Agg, 1, 1)", "ratio", "\u5360\u6bd4"),
    RATIO_90(MetaField.FormulaAggStatus.WithTotal, "#Agg / Total(#Agg, 99, 0)", "ratio", "\u5360\u6bd4"),
    RATIO_09(MetaField.FormulaAggStatus.WithTotal, "#Agg / Total(#Agg, 0, 99)", "ratio", "\u5360\u6bd4"),
    RATIO_99(MetaField.FormulaAggStatus.WithTotal, "#Agg / Total(#Agg, 99, 99)", "ratio", "\u5360\u6bd4");

    private MetaField.FormulaAggStatus _formulaAggStatus;
    private String _function;
    private String _rsKey;
    private String _text;

    private QuickSetup(MetaField.FormulaAggStatus fas, String function, String rsKey, String text) {
        this._formulaAggStatus = fas;
        this._function = function;
        this._rsKey = rsKey;
        this._text = text;
    }

    public String getText(II18nContext i18nCtx) {
        return this._rsKey == null ? this._text : Messages.getLangMessage(i18nCtx, this._rsKey, this._text);
    }

    public MetaField.FormulaAggStatus getFormulaAggStatus() {
        return this._formulaAggStatus;
    }

    public String createFormula(String metaFieldName, Aggregation agg) {
        String sub = agg == Aggregation.AGG ? "[" + metaFieldName + "]" : "func([field])".replace("func", this.getAggregationFunction(agg)).replace("field", metaFieldName);
        String formula = this._function.replaceAll("#Agg", sub);
        return formula;
    }

    private String getAggregationFunction(Aggregation agg) {
        switch (agg) {
            case AVG: {
                return "AVG";
            }
            case MAX: {
                return "MAX";
            }
            case MIN: {
                return "MIN";
            }
            case CNT: {
                return "COUNT";
            }
            case CNTD: {
                return "COUNTD";
            }
        }
        return "SUM";
    }

    public String toPersistance() {
        return this.name();
    }

    public static QuickSetup fromPersistance(String name) {
        try {
            return QuickSetup.valueOf(name);
        }
        catch (Exception ex) {
            return LP;
        }
    }
}

