/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model;

import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.affected.AffectedTargets;
import com.kingdee.bos.qing.dashboard.model.filter.selected.AbstractDefaultSelected;
import com.kingdee.bos.qing.dashboard.model.filter.selected.DefaultSelectedType;
import com.kingdee.bos.qing.dashboard.model.filter.source.AbstractFilterSource;
import com.kingdee.bos.qing.dashboard.model.filter.source.FilterSourceType;
import com.kingdee.bos.qing.dashboard.model.slideshow.AbstractDurationMode;
import com.kingdee.bos.qing.dashboard.model.slideshow.DurationType;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractWidget;
import com.kingdee.bos.qing.dashboard.model.widget.WidgetTypeName;
import com.kingdee.bos.qing.util.JsonUtil;

public class ModelJsonDecoder {
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();

    public static DashboardModel decode(String jsonString) {
        return (DashboardModel)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, DashboardModel.class);
    }

    public static <T> T decode(String jsonString, Class<T> clz) {
        return (T)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, clz);
    }

    static {
        customJsonParser.addCustomDecoder(AbstractWidget.class, (JsonUtil.AbstractJsonDecoder)new WidgetJsonDecoder());
        customJsonParser.addCustomDecoder(AbstractFilterSource.class, (JsonUtil.AbstractJsonDecoder)new FilterSourceJsonDecoder());
        customJsonParser.addCustomDecoder(AbstractDefaultSelected.class, (JsonUtil.AbstractJsonDecoder)new DefaultSelectedJsonDecoder());
        customJsonParser.addCustomDecoder(AffectedTargets.AbstractTargetItem.class, (JsonUtil.AbstractJsonDecoder)new AffectedTargetItemDecoder());
        customJsonParser.addCustomDecoder(AbstractDurationMode.class, (JsonUtil.AbstractJsonDecoder)new DurationModeDecoder());
    }

    private static class DurationModeDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractDurationMode> {
        private DurationModeDecoder() {
        }

        protected AbstractDurationMode decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String typeName = json.getAttrValue("type");
            DurationType type = DurationType.fromPersistance(typeName);
            AbstractDurationMode durationMode = (AbstractDurationMode)this.fromJson(json, type.getDurationModeClass());
            return durationMode;
        }
    }

    private static class AffectedTargetItemDecoder
    extends JsonUtil.AbstractJsonDecoder<AffectedTargets.AbstractTargetItem> {
        private AffectedTargetItemDecoder() {
        }

        protected AffectedTargets.AbstractTargetItem decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String typeName = json.getAttrValue("type");
            Class<? extends AffectedTargets.AbstractTargetItem> clazz = AffectedTargets.getClass(typeName);
            AffectedTargets.AbstractTargetItem item = (AffectedTargets.AbstractTargetItem)this.fromJson(json, clazz);
            return item;
        }
    }

    private static class DefaultSelectedJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractDefaultSelected> {
        private DefaultSelectedJsonDecoder() {
        }

        protected AbstractDefaultSelected decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String typeName = json.getAttrValue("type");
            DefaultSelectedType type = DefaultSelectedType.fromJsonTypeName(typeName);
            AbstractDefaultSelected filterSource = (AbstractDefaultSelected)this.fromJson(json, type.getDefaultSelectedClass());
            return filterSource;
        }
    }

    private static class FilterSourceJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractFilterSource> {
        private FilterSourceJsonDecoder() {
        }

        protected AbstractFilterSource decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String typeName = json.getAttrValue("type");
            FilterSourceType type = FilterSourceType.fromJsonTypeName(typeName);
            AbstractFilterSource filterSource = (AbstractFilterSource)this.fromJson(json, type.getFilterSourceClass());
            return filterSource;
        }
    }

    private static class WidgetJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractWidget> {
        private WidgetJsonDecoder() {
        }

        protected AbstractWidget decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String typeName = json.getAttrValue("widgetType");
            WidgetTypeName widgetTypeName = WidgetTypeName.fromJsonTypeName(typeName);
            AbstractWidget widget = (AbstractWidget)this.fromJson(json, widgetTypeName.getWidgetClass());
            return widget;
        }
    }
}

