/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.linkage.ILinkageStrategy;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunnerForLinkage;
import com.kingdee.bos.qing.core.engine.runner.square.AbstractEngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.AssociatedDataEmptyException;
import com.kingdee.bos.qing.core.exception.InvalidMetaFieldException;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ExecutableValue;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.DataDetailDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinkageDomain
extends AbstractDomain {
    private static Integer LINGKAGE_MAX_NUM = Integer.valueOf(SystemPropertyUtil.getString((String)"qing.linkage.maxnum", (String)"100000"));

    public LinkageDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredForeignKeyMembers cacheForeignKeyMembers(IQingModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, LinkageContext ctx, String foreignKeyMetaFieldFullName, String bizUiId, String tag) throws AnalysisException {
        Set<Object> allMembers;
        StoredForeignKeyMembers response = new StoredForeignKeyMembers();
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeInto(model, additionalFilters);
        }
        IDataSourceVisitor dsVisitor = this.createDataSourceVisitor();
        AnalyticalField foreignKeyField = this.createPropertyField(model.getMeta(), foreignKeyMetaFieldFullName);
        ICorrespondent correspondent = null;
        try {
            AbstractEngine engine;
            Object engineRunner;
            Object target;
            correspondent = LinkageDomain.createExecutingCorrespondent();
            if (model instanceof SquareModel) {
                target = ctx.forSquare();
                ((SquareLinkageClickedTarget)target).mergeInto((SquareModel)model, this.getI18nContext());
                engineRunner = new com.kingdee.bos.qing.core.engine.runner.square.EngineRunnerForLinkage(dsVisitor, (SquareModel)model, this.getI18nContext());
                ((com.kingdee.bos.qing.core.engine.runner.square.EngineRunnerForLinkage)engineRunner).setForeignKeyField(foreignKeyField);
                engine = ((AbstractEngineRunner)engineRunner).run(correspondent);
            } else if (model instanceof AnalyticalModel) {
                target = ctx.forLonger();
                ((LongerLinkageClickedTarget)target).mergeInto((AnalyticalModel)model, this.getI18nContext());
                engineRunner = new EngineRunnerForLinkage(dsVisitor, (AnalyticalModel)model);
                ((com.kingdee.bos.qing.core.engine.runner.longer.AbstractEngineRunner)engineRunner).setContext(this.getI18nContext());
                ((EngineRunnerForLinkage)engineRunner).setForeignKeyField(foreignKeyField);
                engine = ((EngineRunnerForLinkage)engineRunner).run(correspondent);
            } else {
                throw new RuntimeException("Modify here.");
            }
            Cuboid cuboid = engine.getCuboid();
            int aggIdx = this.searchAggregationIndexOfForeignKey(cuboid, foreignKeyField);
            allMembers = this.collectForeignKeyAllMembers(cuboid, aggIdx, response);
            allMembers.removeAll(Collections.singleton(null));
            if (allMembers.isEmpty()) {
                throw new AssociatedDataEmptyException();
            }
            cuboid = null;
            engine = null;
        }
        finally {
            LinkageDomain.destroyExecutingCorrespondent(correspondent);
        }
        String storeKey = this.cacheAllMembers(allMembers, foreignKeyMetaFieldFullName, bizUiId, tag);
        response.setForeignKeyMembersCachedId(storeKey);
        return response;
    }

    private AnalyticalField createPropertyField(Meta meta, String foreignKeyMetaFieldFullName) throws InvalidMetaFieldException {
        MetaField foreignKeyMetaField = meta.createSearchingMap().get(foreignKeyMetaFieldFullName);
        if (foreignKeyMetaField == null) {
            throw InvalidMetaFieldException.createForLinkageForeignKeyNotExist();
        }
        AnalyticalField field = new AnalyticalField();
        field.setName(foreignKeyMetaFieldFullName);
        field.setRole("measure");
        field.setAggregation(Aggregation.PROPERTIES);
        field.bindMetaField(foreignKeyMetaField);
        return field;
    }

    private int searchAggregationIndexOfForeignKey(Cuboid cuboid, AnalyticalField foreignKeyField) {
        List<AnalyticalField> measureFields = cuboid.getMeasureFields();
        for (int i = 0; i < measureFields.size(); ++i) {
            if (foreignKeyField != measureFields.get(i)) continue;
            return i;
        }
        throw new RuntimeException("Impossible");
    }

    private Set<Object> collectForeignKeyAllMembers(Cuboid cuboid, int aggIdx, StoredForeignKeyMembers response) {
        Aggregator agg = null;
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            Aggregator[] aggregators = cuboid.getCellAggregators(it.next());
            Aggregator one = aggregators[aggIdx];
            boolean isContinueAdd = this.limitAdd(agg, one);
            if (agg == null) {
                agg = one;
            } else {
                agg.add(one);
            }
            if (isContinueAdd) continue;
            response.setLinkageMaxNums(LINGKAGE_MAX_NUM);
            break;
        }
        if (agg == null) {
            return Collections.emptySet();
        }
        return ((Aggregator.Properties)agg).getDistinctValues();
    }

    private boolean limitAdd(Aggregator parentAgg, Aggregator currentAgg) {
        int currentCount;
        Aggregator.Properties parentProperties = null;
        Aggregator.Properties currentProperties = null;
        if (parentAgg != null) {
            parentProperties = (Aggregator.Properties)parentAgg;
        }
        if (currentAgg != null) {
            currentProperties = (Aggregator.Properties)currentAgg;
        }
        int totalCount = parentAgg == null ? 0 : parentProperties.getValueCount();
        int n = currentCount = currentAgg == null ? 0 : currentProperties.getValueCount();
        if (totalCount + currentCount >= LINGKAGE_MAX_NUM) {
            int needRemoveCount = totalCount + currentCount - LINGKAGE_MAX_NUM;
            if (needRemoveCount > 0) {
                Iterator iterator = currentProperties.getDistinctValues().iterator();
                while (needRemoveCount > 0) {
                    if (iterator.hasNext() && iterator.next() != null) {
                        iterator.remove();
                    }
                    --needRemoveCount;
                }
            }
            return false;
        }
        return true;
    }

    private String cacheAllMembers(Set<Object> allMembers, String foreignKeyMetaFieldFullName, String bizUiId, String tag) {
        ILinkageStrategy linkageService = (ILinkageStrategy)CustomStrategyRegistrar.getStrategy(ILinkageStrategy.class);
        if (null != linkageService) {
            String storeKey = linkageService.storeLinkageForeignKeys(allMembers, foreignKeyMetaFieldFullName, bizUiId, tag);
            return storeKey;
        }
        return null;
    }

    public static class SquareLinkageClickedTarget {
        private List<Item> items;

        public void mergeInto(SquareModel model, II18nContext i18nCtx) {
            Map<String, MetaField> metaFields = model.getMeta().createSearchingMap();
            for (Item item : this.items) {
                AnalyticalField field = SquareLinkageClickedTarget.makeAnalyticalField(item, metaFields);
                AbstractAnalyticalFilter filter = SquareLinkageClickedTarget.makeFilter(item, field, i18nCtx);
                FilterItem filterItem = new FilterItem();
                filterItem.setField(field);
                filterItem.setFilter(filter);
                model.getFilters().add(filterItem);
            }
        }

        private static AnalyticalField makeAnalyticalField(Item item, Map<String, MetaField> metaFields) {
            AnalyticalField field = new AnalyticalField();
            field.setName(item.getMetaFieldFullName());
            if (item.getPartValue() != null) {
                field.setPartValue(PartValue.valueOf(item.getPartValue()));
            }
            field.setRole("dimension");
            field.fixMetaFieldBinding(metaFields);
            if (field.isParentChildDimension()) {
                MetaField mf = field.getParentChildDimensionIdField();
                field.setName(mf.getFullName());
                field.bindMetaField(mf);
            }
            return field;
        }

        private static AbstractAnalyticalFilter makeFilter(Item item, AnalyticalField field, II18nContext i18nCtx) {
            String selectedComplexValue = item.getSelectedValue();
            List<ExecutableValue> list = ExecutableValueCoder.decodeComplexValue(selectedComplexValue);
            FilterPreparedValueGainer.GainerPeers gainerPeer = new FilterPreparedValueGainer.GainerPeers(field, i18nCtx);
            gainerPeer.setAppointedAsTree(false);
            for (ExecutableValue ev : list) {
                gainerPeer.gain(ev.getOriginalValue());
            }
            List<String> selecteds = gainerPeer.getAllPreparedValue();
            DiscreteFilter filter = new DiscreteFilter();
            filter.setSelecteds(selecteds);
            return filter;
        }

        public static class Item {
            private String fieldName;
            private String partValue;
            private String value;

            private String getMetaFieldFullName() {
                return this.fieldName;
            }

            private String getSelectedValue() {
                return this.value;
            }

            private String getPartValue() {
                return this.partValue;
            }
        }
    }

    public static class LongerLinkageClickedTarget
    extends DataDetailDomain.TableViewCoordinate {
        public void mergeInto(AnalyticalModel model, II18nContext i18nCtx) {
            super.addFilterToModel(model, i18nCtx);
        }
    }

    public static class LinkageContext {
        private LongerLinkageClickedTarget forLonger;
        private SquareLinkageClickedTarget forSquare;

        public static LinkageContext decodeFromJson(String jsonString) {
            return (LinkageContext)JsonUtil.decodeFromString((String)jsonString, LinkageContext.class);
        }

        public LongerLinkageClickedTarget forLonger() {
            return this.forLonger;
        }

        public SquareLinkageClickedTarget forSquare() {
            return this.forSquare;
        }
    }

    public static class StoredForeignKeyMembers {
        private String foreignKeyMembersCachedId;
        private int linkageMaxNums;

        public void setForeignKeyMembersCachedId(String foreignKeyMembersCachedId) {
            this.foreignKeyMembersCachedId = foreignKeyMembersCachedId;
        }

        public void setLinkageMaxNums(int linkageMaxNums) {
            this.linkageMaxNums = linkageMaxNums;
        }
    }
}

