/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.monitor;

import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.monitor.Correspondent;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.monitor.IMemoryOccupant;
import com.kingdee.bos.qing.monitor.StateBean;
import com.kingdee.bos.qing.monitor.config.IPerformanceConfig;
import com.kingdee.bos.qing.monitor.config.PerformanceConfig;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RuntimeMonitor {
    private static IPerformanceConfig _config;
    private static final int ONE_TIME_RESERVED_MEMORY = 64000;
    private static List<Correspondent> _all;
    private static long _allUsableMemory;
    private static long _usedMemory;
    private static MemoryBeggingHandler _memoryBeggingHandler;
    private static boolean _toCollectStateSnapshot;
    private static List<String> _stateSnapshots;

    public static void setConfig(IPerformanceConfig config) {
        _config = config;
        RuntimeMonitor.reset();
    }

    public static IPerformanceConfig getConfig() {
        if (_config == null) {
            _config = new PerformanceConfig();
        }
        return _config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICorrespondent regist(String tag) throws EnvCeilingException {
        if (RuntimeMonitor.getUsableMemory() - _usedMemory < 64000L) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug((String)("Qing.Monitor.regist: denied! " + tag));
            }
            throw EnvCeilingException.createRequestDenied(64000L);
        }
        Correspondent correspondent = new Correspondent(tag);
        correspondent.setBeggingListener(_memoryBeggingHandler);
        correspondent.applyForMemory(0, 8192L);
        List<Correspondent> list = _all;
        synchronized (list) {
            _all.add(correspondent);
        }
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("Qing.Monitor.regist: " + correspondent));
        }
        return correspondent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregist(ICorrespondent correspondent) {
        List<Correspondent> list = _all;
        synchronized (list) {
            Iterator<Correspondent> it = _all.iterator();
            while (it.hasNext()) {
                if (correspondent != it.next()) continue;
                long oldBytes = ((IMemoryOccupant)((Object)correspondent)).getUsedBytes();
                RuntimeMonitor.updateMemoryUsed(oldBytes, 0L);
                it.remove();
                break;
            }
        }
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("Qing.Monitor.unregist: " + correspondent));
        }
    }

    public static void stopByUser(String tag) {
        for (Correspondent correspondent : _all) {
            if (!tag.equals(correspondent.getTag())) continue;
            correspondent.stopByUser();
            if (!LogUtil.isDebugEnabled()) continue;
            LogUtil.debug((String)("Qing.Monitor.userStop: " + correspondent));
        }
    }

    private static synchronized void reset() {
        _allUsableMemory = -1L;
    }

    private static synchronized long getUsableMemory() {
        if (_allUsableMemory < 0L) {
            long max = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
            if (max == -1L && (max = Runtime.getRuntime().maxMemory()) == Long.MAX_VALUE) {
                max = 512000000L;
            }
            double percent = RuntimeMonitor.getConfig().getUsableMemoryRatio();
            percent = Math.max(Math.min(percent, 1.0), 0.0);
            _allUsableMemory = (long)((double)max * percent);
        }
        return _allUsableMemory;
    }

    private static synchronized IMemoryOccupant.Reply updateMemoryUsed(long oldBytes, long newBytes) {
        long used = _usedMemory - oldBytes + newBytes;
        if (used > RuntimeMonitor.getUsableMemory()) {
            if (newBytes > RuntimeMonitor.getUsableMemory()) {
                return new IMemoryOccupant.GiveUp(RuntimeMonitor.getUsableMemory());
            }
            return IMemoryOccupant.TryAgain;
        }
        if (_toCollectStateSnapshot) {
            RuntimeMonitor.keepStateSnapshot();
        }
        _usedMemory = used;
        return IMemoryOccupant.HereYouAre;
    }

    private static void keepStateSnapshot() {
        String last;
        StateBean.Snapshot snapshot = new StateBean.Snapshot();
        snapshot.setUsedMemory(_usedMemory);
        snapshot.setRunning(_all);
        String json = JsonUtil.encodeToString((Object)snapshot);
        if (_stateSnapshots == null) {
            _stateSnapshots = new ArrayList<String>();
        }
        if (_stateSnapshots.size() > 0 && (last = _stateSnapshots.get(_stateSnapshots.size() - 1)).equals(json)) {
            return;
        }
        _stateSnapshots.add(json);
    }

    public static StateBean getStateBean(Boolean startOtherwiseStop) {
        if (startOtherwiseStop == Boolean.TRUE) {
            _toCollectStateSnapshot = true;
        } else if (startOtherwiseStop == Boolean.FALSE) {
            _toCollectStateSnapshot = false;
        }
        StateBean bean = new StateBean();
        bean.setHeapMax(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        bean.setXmx(Runtime.getRuntime().maxMemory());
        bean.setConfigRatio(RuntimeMonitor.getConfig().getUsableMemoryRatio());
        bean.setConfigMaxCell(RuntimeMonitor.getConfig().getMaxCubeCells());
        bean.setReserveMemory(RuntimeMonitor.getUsableMemory());
        bean.setSnapshotsJson(_stateSnapshots);
        if (_stateSnapshots != null) {
            _stateSnapshots = null;
        }
        return bean;
    }

    static {
        _all = new ArrayList<Correspondent>();
        _allUsableMemory = -1L;
        _usedMemory = 0L;
        _memoryBeggingHandler = new MemoryBeggingHandler();
        _toCollectStateSnapshot = false;
    }

    private static class MemoryBeggingHandler
    implements IMemoryOccupant.IBeggingListener {
        private MemoryBeggingHandler() {
        }

        @Override
        public IMemoryOccupant.Reply beg(long oldBytes, long newBytes) {
            return RuntimeMonitor.updateMemoryUsed(oldBytes, newBytes);
        }
    }
}

