/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.data.domain.handler.impl.ColumnToRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.FileResult;
import com.kingdee.bos.qing.data.domain.source.file.domain.ExcelSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.domain.IFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.domain.QSFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.domain.TextSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.domain.XMLSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.parser.FileEncodingParser;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.exception.AbstractFileSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.FileSource;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.util.DataTypeUtils;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.data.util.formate.DateFormateHelper;
import com.kingdee.bos.qing.data.util.formate.DateFormateMatchResult;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.com.google.common.collect.Sets;

public abstract class AbstractFileSourceDomain
extends AbstractDataSourceDomain
implements IFileSourceDomain {
    public static String guessFileEncoding(String fileName) throws AbstractFileSourceException {
        return FileEncodingParser.guessFileEncoding(fileName);
    }

    public static AbstractFileSourceDomain newInstance(AbstractSource source) throws UnSupportDataSourceException {
        FileSource fileSource = (FileSource)source;
        return AbstractFileSourceDomain.newInstance(fileSource.getFileType());
    }

    public static AbstractFileSourceDomain newInstance(FileSource.FileType fileType) throws UnSupportDataSourceException {
        switch (fileType) {
            case EXCEL: {
                return ExcelSourceDomain.newInstance();
            }
            case XML: {
                return XMLSourceDomain.newInstance();
            }
            case CSV: {
                return new TextSourceDomain(".csv");
            }
            case TXT: {
                return new TextSourceDomain(".txt");
            }
        }
        throw new UnSupportDataSourceException("unsupport FileType:" + fileType);
    }

    @Override
    public boolean canEntityChangeOnline() {
        return true;
    }

    @Override
    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
    }

    @Override
    public List<Map<String, Object>> filterRow(int rowNum, Map<String, String> row, IRuntimeFilter runtimeFiler, RuntimeEntity runtimeEntity, ResultContent handler) {
        ColumnToRowDataHandler dataHandler;
        List<Map<String, Object>> rowDataList;
        ThreadCache.getRow().clear();
        this.convert(rowNum, row, runtimeFiler, runtimeEntity, handler);
        if (runtimeEntity.getDataSourcePersistentWriter() != null) {
            Object[] objects = AbstractFileSourceDomain.getOutputData(ThreadCache.getRow(), runtimeEntity.getSourceRuntimeEntity(), false);
            try {
                runtimeEntity.getDataSourcePersistentWriter().writeData(objects);
            }
            catch (DataSourcePersistenceException e) {
                runtimeEntity.getDataSourcePersistentWriter().close((Exception)((Object)e));
                runtimeEntity.setDataSourcePersistentWriter(null);
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                runtimeEntity.getDataSourcePersistentWriter().close((Exception)e);
                runtimeEntity.setDataSourcePersistentWriter(null);
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(rowDataList = (dataHandler = new ColumnToRowDataHandler()).columnToRow(ThreadCache.getRow(), runtimeEntity))) {
            ArrayList<Map<String, Object>> resultList = null;
            for (Map<String, Object> rowMap : rowDataList) {
                Map<String, Object> result;
                if ((runtimeFiler == null || !runtimeFiler.innerExcuteFilterWtihRawValue(rowMap)) && runtimeFiler != null || (result = this.filterCalculateColumn(rowMap, runtimeEntity)) == null) continue;
                if (resultList == null) {
                    resultList = new ArrayList<Map<String, Object>>();
                }
                resultList.add(result);
            }
            return resultList;
        }
        return null;
    }

    public Map<String, Object> convert(int rowNum, Map<String, String> row, IRuntimeFilter runtimeFiler, RuntimeEntity runtimeEntity, ResultContent handler) {
        List<RuntimeProperty> selectedPriProperties = runtimeEntity.getSelectedPriProperties();
        for (RuntimeProperty selectedPriProperty : selectedPriProperties) {
            String v;
            String selectedPriPropertyName = selectedPriProperty.getName();
            String selectedPriPropertyAssociateName = selectedPriProperty.getAssociateName();
            if (null == row || (v = row.get(selectedPriPropertyAssociateName)) == null) continue;
            DataType t = selectedPriProperty.getInputDataType();
            Object o = null;
            try {
                o = this.getColumnValue(t, v);
            }
            catch (Exception ex) {
                ThreadCache.getRow().put(selectedPriPropertyName, null);
            }
            ThreadCache.getRow().put(selectedPriPropertyName, o);
        }
        return null;
    }

    @Override
    public Map<String, Object> filterCalculateColumn(Map<String, Object> primaryRowData, RuntimeEntity runtimeEntity) {
        return AbstractDataSourceDomain.getRowDataAfterCalculateAndFilter(primaryRowData, runtimeEntity);
    }

    @Override
    protected boolean isDataFieldUnique(QingContext qingContext, RuntimeEntity runtimeEntity, RuntimeProperty fieldName) throws AbstractFileSourceException {
        return false;
    }

    protected String calculateType(FileResult result, String col, int defineTypeRowCount) {
        int rowCount = result.getTotalRowCount();
        HashSet set = Sets.newHashSet();
        for (int r = 1; r <= rowCount; ++r) {
            if (null == result.getOriginalRow().get(r)) continue;
            String v = result.getOriginalRow().get(r).get(col);
            if (!StringUtils.isBlank((CharSequence)v)) {
                set.add(this.getColumnClassName(v));
            }
            if (r == defineTypeRowCount || set.contains("java.lang.String")) break;
        }
        if (set.size() > 1) {
            return this.calculate(set);
        }
        return set.size() > 0 ? set.toArray()[0].toString() : "java.lang.String";
    }

    @Override
    public String calculateType2(String v) {
        return this.getColumnClassName(v);
    }

    @Override
    public String calculate(Set<String> set) {
        return AbstractFileSourceDomain.caculateColumnType(set);
    }

    public static String caculateColumnType(Set<String> set) {
        if (null == set || set.isEmpty()) {
            return "java.lang.String";
        }
        if (set.contains("java.lang.String") || set.contains("java.lang.Double") && set.contains("java.util.Date") || set.contains("java.lang.Double") && set.contains("java.lang.Boolean") || set.contains("java.lang.Long") && set.contains("java.util.Date") || set.contains("java.lang.Long") && set.contains("java.lang.Boolean") || set.contains("java.util.Date") && set.contains("java.lang.Boolean")) {
            return "java.lang.String";
        }
        if (set.contains("java.lang.Double")) {
            return "java.lang.Double";
        }
        if (set.contains("java.lang.Long")) {
            return "java.lang.Long";
        }
        if (set.contains("java.sql.Time")) {
            return "java.sql.Time";
        }
        if (set.contains("java.util.Date")) {
            return "java.util.Date";
        }
        if (set.contains("java.lang.Boolean")) {
            return "java.lang.Boolean";
        }
        return "java.lang.String";
    }

    protected String getColumnClassName(String v) {
        return DataTypeUtils.getDataTypeClassName(v);
    }

    protected Object getColumnValue(DataType type, String v) throws NumberFormatException, ParseException {
        if (DataType.STRING.equals((Object)type)) {
            return v;
        }
        if (StringUtils.isBlank((CharSequence)v)) {
            return null;
        }
        v = v.trim();
        Object result = "";
        switch (type) {
            case STRING: {
                result = v;
                break;
            }
            case BOOLEAN: {
                result = Boolean.parseBoolean(v);
                break;
            }
            case INT: {
                BigDecimal decimalInt = new BigDecimal(v.replace(",", ""));
                decimalInt = decimalInt.setScale(0);
                result = decimalInt;
                break;
            }
            case NUMBER: {
                BigDecimal decimal = new BigDecimal(v.replace(",", ""));
                if (decimal.scale() > 15) {
                    decimal = decimal.setScale(15, RoundingMode.HALF_UP);
                }
                result = decimal;
                break;
            }
            case DATE: 
            case DATETIME: {
                DateFormateMatchResult matchResult = DateFormateHelper.executeMatch(v);
                if (matchResult.isSucceed()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(DateUtils.stringToDate(v, matchResult.getDateFormate()));
                    result = calendar;
                    break;
                }
                throw new ParseException("date value parse exception", 0);
            }
            default: {
                return null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException, InterruptedException, QingLockRequireException {
        EntityExtractContext context = runtimeEntity.getEntityExtractContext();
        if (context == null) {
            return this.doExtractData(qingContext, dataSourceWriter, runtimeEntity, progressProcessor);
        }
        try {
            context.initReadQingFileVisitor(runtimeEntity.getOrinalEntity());
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        Entity entity = context.getQsEntity();
        AbstractSource source = context.getSource(entity.getSource());
        Set<String> whitePropertySet = context.getWhitePropertySet();
        IQingFileVisitor qingFileVisitor = context.getReadQingFile(entity);
        if (qingFileVisitor != null) {
            QSFileSourceDomain qsFileSourceDomain = new QSFileSourceDomain();
            return qsFileSourceDomain.extractDataFromQSFile(this, dataSourceWriter, runtimeEntity, progressProcessor, qingFileVisitor);
        }
        Object writerOrVisitor = null;
        if (context.getSubjectEntityExtractDataCallBack() != null) {
            block17: {
                String lockKey = context.getEntityUniqueKey(source, entity);
                ILock lock = LockFactory.createLock((String)lockKey);
                try {
                    QSDataSourceWriter dataSourcePersistentWriter;
                    boolean isSuccess;
                    if (!this.toLock(lock) || !((writerOrVisitor = this.getQSFileWriterOrVisitor(context, source, entity)) instanceof QSDataSourceWriter) || !(isSuccess = this.extractEntityDataAndCreateQSInitSuccess(dataSourcePersistentWriter = (QSDataSourceWriter)writerOrVisitor, this, context, whitePropertySet, source, entity, runtimeEntity))) break block17;
                    String result = this.doExtractData(context.getQingContext(), dataSourceWriter, runtimeEntity, progressProcessor);
                    dataSourcePersistentWriter = runtimeEntity.getDataSourcePersistentWriter();
                    if (dataSourcePersistentWriter != null) {
                        Exception exception = null;
                        boolean writeSuccess = false;
                        try {
                            dataSourcePersistentWriter.finishWriteData();
                            writeSuccess = true;
                        }
                        catch (Exception e) {
                            exception = e;
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            dataSourcePersistentWriter.close(exception);
                        }
                        if (writeSuccess) {
                            context.addQSFile(context.getWriteQingFile(entity), source, entity);
                        } else {
                            context.removeConvertingQSFlagFromCache(context.getThemeId(), ((FileSource)source).getFileUrl(), entity.getName());
                        }
                    }
                    String string = result;
                    return string;
                }
                finally {
                    lock.unlock();
                }
            }
            if (writerOrVisitor instanceof IQingFileVisitor) {
                qingFileVisitor = (IQingFileVisitor)writerOrVisitor;
                QSFileSourceDomain qsFileSourceDomain = new QSFileSourceDomain();
                return qsFileSourceDomain.extractDataFromQSFile(this, dataSourceWriter, runtimeEntity, progressProcessor, qingFileVisitor);
            }
        }
        return this.doExtractData(context.getQingContext(), dataSourceWriter, runtimeEntity, progressProcessor);
    }

    private boolean extractEntityDataAndCreateQSInitSuccess(QSDataSourceWriter dataSourcePersistentWriter, AbstractDataSourceDomain domain, EntityExtractContext context, Set<String> whitePropertySet, AbstractSource source, Entity entity, RuntimeEntity runtimeEntity) {
        try {
            DesigntimeDataObject designtimeDataObject = domain.getDesigntimeDataObject(context.getQingContext(), source, entity.getAssociateName());
            Entity sourceEntity = context.getSourceEntity(designtimeDataObject, entity);
            RuntimeEntity sourceRuntimeEntity = domain.newRuntimeEntity(sourceEntity, context.getEntityNamesMap(), whitePropertySet, source, context.getQingContext(), context.getOwnerId());
            sourceRuntimeEntity.init(null);
            dataSourcePersistentWriter.start(sourceRuntimeEntity.getMetaInfo());
            runtimeEntity.setDataSourcePersistentWriter(dataSourcePersistentWriter);
            runtimeEntity.setSourceRuntimeEntity(sourceRuntimeEntity);
            context.setConvertingQSFlagToCache(context.getThemeId(), ((FileSource)source).getFileUrl(), entity.getName());
            return true;
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            dataSourcePersistentWriter.close(e);
            return false;
        }
    }

    private boolean toLock(ILock lock) {
        try {
            lock.lock();
            return true;
        }
        catch (InterruptedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        catch (QingLockRequireException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private Object getQSFileWriterOrVisitor(EntityExtractContext context, AbstractSource source, Entity entity) {
        try {
            return context.getQSFileWriterOrVisitor(source, entity, context.getThemeId());
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int topN) throws AbstractSourceException {
        IQingFileVisitor qingFileVisitor = this.getQingFileVisitor(runtimeEntity);
        if (qingFileVisitor != null) {
            QSFileSourceDomain qSFileSourceDomain = new QSFileSourceDomain();
            return qSFileSourceDomain.previewDataFromQSFile(this, runtimeEntity, topN, qingFileVisitor);
        }
        return this.doGetPreviewData(qingContext, runtimeEntity, topN);
    }

    @Override
    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        IQingFileVisitor qingFileVisitor = this.getQingFileVisitor(runtimeEntity);
        if (qingFileVisitor != null) {
            QSFileSourceDomain qSFileSourceDomain = new QSFileSourceDomain();
            return qSFileSourceDomain.getDataCountFromQSFile(this, runtimeEntity, qingFileVisitor);
        }
        return this.doGetDataCount(qingContext, runtimeEntity);
    }

    private IQingFileVisitor getQingFileVisitor(RuntimeEntity runtimeEntity) {
        EntityExtractContext entityExtractContext = runtimeEntity.getEntityExtractContext();
        IQingFileVisitor readQingFile = null;
        if (entityExtractContext != null) {
            Entity entity = entityExtractContext.getQsEntity();
            readQingFile = entityExtractContext.getReadQingFile(entity);
        }
        return readQingFile != null ? (readQingFile.exists() ? readQingFile : null) : null;
    }

    protected abstract long doGetDataCount(QingContext var1, RuntimeEntity var2) throws AbstractSourceException;

    protected abstract PreviewDataModel doGetPreviewData(QingContext var1, RuntimeEntity var2, int var3) throws AbstractSourceException;

    protected abstract String doExtractData(QingContext var1, IDataSourceWriter var2, RuntimeEntity var3, ProgressProcessor var4) throws AbstractSourceException, DataSourcePersistenceException, InterruptedException;
}

