/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.domain;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.handler.impl.ColumnToRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileAccessException;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QSFileSourceDomain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String extractDataFromQSFile(AbstractFileSourceDomain fileSourceDomain, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor newProgress, IQingFileVisitor qingFileVisitor) throws DataSourcePersistenceException, InterruptedException, AbstractSourceException {
        TraceSpan traceSpan;
        block3: {
            String string;
            traceSpan = null;
            try {
                traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"readDataTable", (String)"\u8bfb\u53d6\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + runtimeEntity.getAlias() + Messages.getMLS((String)"flatDataChangeFile", (String)"]\u5e73\u9762\u6570\u636e\u8f6c\u6362\u6587\u4ef6", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
                traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractDataFromQSFile");
                traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getName());
                traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getAlias());
                RuntimeFilterUtil.Prediction prediction = fileSourceDomain.initRuntimeFilter(runtimeEntity);
                if (!prediction.isAlwaysFalse()) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                TracerUtil.close(traceSpan);
                throw throwable;
            }
            TracerUtil.close((TraceSpan)traceSpan);
            return string;
        }
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        RunningTimeParams runningTimeParams = new RunningTimeParams();
        runningTimeParams.setRuntimeFilter(iRuntimeFilter);
        runningTimeParams.setRuntimeEntity(runtimeEntity);
        runningTimeParams.setDataSourceWriter(dataSourceWriter);
        runningTimeParams.setPreview(false);
        runningTimeParams.setTopN(-2);
        runningTimeParams.setFileSourceDomain(fileSourceDomain);
        String string = this.extractDataFromQSFile(runningTimeParams, newProgress, qingFileVisitor);
        TracerUtil.close((TraceSpan)traceSpan);
        return string;
    }

    public PreviewDataModel previewDataFromQSFile(AbstractFileSourceDomain fileSourceDomain, RuntimeEntity runtimeEntity, int topN, IQingFileVisitor qingFileVisitor) throws AbstractSourceException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        RuntimeFilterUtil.Prediction prediction = fileSourceDomain.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return new PreviewDataModel(result);
        }
        RunningTimeParams runningTimeParams = new RunningTimeParams();
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        runningTimeParams.setRuntimeFilter(iRuntimeFilter);
        runningTimeParams.setRuntimeEntity(runtimeEntity);
        runningTimeParams.setSource(runtimeEntity.getSource());
        runningTimeParams.setTopN(topN);
        runningTimeParams.setPreview(true);
        runningTimeParams.setFileSourceDomain(fileSourceDomain);
        try {
            this.readDataFromQSFile(runningTimeParams, null, result, OperationTypeEnum.PREVIEWDATA, qingFileVisitor);
        }
        catch (DataSourcePersistenceException e) {
            throw new FileSourceFileAccessException(e);
        }
        catch (InterruptedException e) {
            throw new FileSourceFileAccessException(e);
        }
        return new PreviewDataModel(result, null);
    }

    private String extractDataFromQSFile(RunningTimeParams runningTimeParams, ProgressProcessor progressProcessor, IQingFileVisitor qsFile) throws DataSourcePersistenceException, InterruptedException, AbstractSourceException {
        return String.valueOf(this.readDataFromQSFile(runningTimeParams, progressProcessor, null, OperationTypeEnum.EXTRACTDATA, qsFile));
    }

    public long getDataCountFromQSFile(AbstractFileSourceDomain fileSourceDomain, RuntimeEntity runtimeEntity, IQingFileVisitor qingFileVisitor) throws AbstractSourceException {
        RuntimeFilterUtil.Prediction prediction = fileSourceDomain.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return 0L;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        RunningTimeParams runningTimeParams = new RunningTimeParams();
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        runningTimeParams.setRuntimeFilter(iRuntimeFilter);
        runningTimeParams.setRuntimeEntity(runtimeEntity);
        runningTimeParams.setSource(runtimeEntity.getSource());
        runningTimeParams.setTopN(-2);
        runningTimeParams.setPreview(true);
        runningTimeParams.setFileSourceDomain(fileSourceDomain);
        try {
            return this.readDataFromQSFile(runningTimeParams, null, result, OperationTypeEnum.GETCOUNT, qingFileVisitor);
        }
        catch (DataSourcePersistenceException e) {
            throw new FileSourceFileAccessException(e);
        }
        catch (InterruptedException e) {
            throw new FileSourceFileAccessException(e);
        }
    }

    private long readDataFromQSFile(RunningTimeParams runningTimeParams, ProgressProcessor progressProcessor, List<Object[]> result, OperationTypeEnum operationTypeEnum, IQingFileVisitor qsFile) throws DataSourcePersistenceException, AbstractSourceException, InterruptedException {
        long count = 0L;
        try (IDataIterator dataIterator = null;){
            QSDataSourceVisitor qsDataSourceVisitor = new QSDataSourceVisitor(qsFile);
            MetaInfo metaInfo = qsDataSourceVisitor.getMetaInfo();
            HashSet<DSFieldKey> fields = new HashSet<DSFieldKey>(16);
            List fieldNames = metaInfo.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                fields.add(new DSFieldKey((String)fieldNames.get(i)));
            }
            if (!qsDataSourceVisitor.hasData()) {
                long i = 0L;
                return i;
            }
            dataIterator = qsDataSourceVisitor.iterator();
            dataIterator.init(fields, null, null);
            int previewRows = runningTimeParams.getTopN();
            boolean isPreview = operationTypeEnum == OperationTypeEnum.PREVIEWDATA;
            Map<String, String> fieldDisplayNameMap = this.getFieldDisplayNameMap(metaInfo);
            IDataSourceWriter dataSourceWriter = runningTimeParams.getDataSourceWriter();
            ColumnToRowDataHandler dataHandler = new ColumnToRowDataHandler();
            block9: while (dataIterator.hasNextRow() && (!isPreview || previewRows > result.size())) {
                Map row = dataIterator.nextRow();
                List<Map<String, Object>> listMap = dataHandler.columnToRow(row, runningTimeParams.getRuntimeEntity());
                if (!CollectionUtils.isNotEmpty(listMap)) continue;
                for (Map<String, Object> rowMap : listMap) {
                    Object[] oneRowData;
                    if (isPreview && previewRows <= result.size() || (oneRowData = this.doFilterAndGetOutputData(rowMap, runningTimeParams, fieldDisplayNameMap)) == null) continue;
                    if (isPreview) {
                        result.add(oneRowData);
                        continue;
                    }
                    if (operationTypeEnum == OperationTypeEnum.EXTRACTDATA) {
                        if (progressProcessor != null) {
                            progressProcessor.dealOneRow();
                            if (progressProcessor.isDataLimit()) continue block9;
                            dataSourceWriter.writeData(oneRowData);
                            progressProcessor.writeOneRow();
                            continue;
                        }
                        dataSourceWriter.writeData(oneRowData);
                        continue;
                    }
                    if (operationTypeEnum != OperationTypeEnum.GETCOUNT) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private void refixEntityPropInputType(RuntimeEntity runtimeEntity, MetaInfo qsMeta, Map<String, Integer> fieldNameIndexInMeta) {
        List<RuntimeProperty> properties = runtimeEntity.getAllProperties();
        for (RuntimeProperty rp : properties) {
            List<RuntimeProperty> runtimeProperties;
            Integer fieldIndexInMeta = fieldNameIndexInMeta.get(rp.getName());
            if (null == fieldIndexInMeta) continue;
            DataType dt = qsMeta.getFieldDataType(fieldIndexInMeta.intValue());
            rp.setInputDataType(dt);
            if (rp.getInputDataType() == rp.getOutputDataType() || (runtimeProperties = runtimeEntity.getNeedToChangeTypeSelectedPriProperties()).indexOf(rp) != -1) continue;
            runtimeProperties.add(rp);
        }
    }

    private Object[] doFilterAndGetOutputData(Map<String, Object> rowData, RunningTimeParams runningTimeParams, Map<String, String> fieldDisplayNameMap) {
        Map<String, Object> filterRow = null;
        rowData = this.convertToInputDataType(runningTimeParams, rowData, fieldDisplayNameMap);
        IRuntimeFilter runtimeFiler = runningTimeParams.getRuntimeFilter();
        if (runtimeFiler != null && runtimeFiler.innerExcuteFilterWtihRawValue(rowData) || runtimeFiler == null) {
            filterRow = runningTimeParams.getFileSourceDomain().filterCalculateColumn(rowData, runningTimeParams.getRuntimeEntity());
        }
        if (MapUtils.isNotEmpty(filterRow)) {
            return AbstractDataSourceDomain.getOutputData(filterRow, runningTimeParams.getRuntimeEntity(), runningTimeParams.isPreview());
        }
        return null;
    }

    private Map<String, Object> convertToInputDataType(RunningTimeParams runningTimeParams, Map<String, Object> rowData, Map<String, String> fieldDisplayNameMap) {
        RuntimeEntity runtimeEntity = runningTimeParams.getRuntimeEntity();
        Map<String, RuntimeProperty> selectedPriAssociatePropertyMap = runtimeEntity.getSelectedPriAssociatePropertyMap();
        Map<String, RuntimeProperty> includeColToRowPropertyMap = runtimeEntity.getOutputPropertyMap();
        HashMap<String, Object> resultRow = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rowData.entrySet()) {
            String propertyName = entry.getKey();
            RuntimeProperty rp = selectedPriAssociatePropertyMap.get(propertyName);
            if (rp == null) {
                rp = selectedPriAssociatePropertyMap.get(fieldDisplayNameMap.get(propertyName));
            }
            if (rp == null) {
                rp = includeColToRowPropertyMap.get(propertyName);
            }
            if (null == rp) continue;
            Object value = rowData.get(entry.getKey());
            DataType inputDataType = rp.getInputDataType();
            if (DataType.BOOLEAN == inputDataType) {
                value = Boolean.valueOf((String)value);
            }
            resultRow.put(rp.getName(), value);
        }
        return resultRow;
    }

    private Map<String, String> getFieldDisplayNameMap(MetaInfo metaInfo) {
        List fieldDisplayNames = metaInfo.getFieldDisplayNames();
        List fieldNames = metaInfo.getFieldNames();
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldDisplayName = (String)fieldDisplayNames.get(i);
            fieldDisplayName = fieldDisplayName.replaceAll("[\t\r\n]+", " ");
            resultMap.put((String)fieldNames.get(i), fieldDisplayName);
        }
        return resultMap;
    }

    static enum OperationTypeEnum {
        PREVIEWDATA,
        EXTRACTDATA,
        GETCOUNT;

    }
}

