/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.MergeCellRange;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.IRowDataHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;

public class Excel07SaxReaderContext {
    public static final int MAX_COL_SIZE = 1024;
    private SharedStringsTable sharedStringsTable;
    private StylesTable stylesTable;
    private CellInfo currentCell;
    private List<CellInfo> currentRowCellList;
    private IRowDataHandler rowDataHandler;
    private Map<String, MergeCellRange> mergeCellRanges = new HashMap<String, MergeCellRange>();
    private List<MergeCellRange> unrepeatedMergeCells = new ArrayList<MergeCellRange>();

    public IRowDataHandler getRowDataHandler() {
        return this.rowDataHandler;
    }

    public void setRowDataHandler(IRowDataHandler rowDataHandler) {
        this.rowDataHandler = rowDataHandler;
    }

    public void setCurrentRowCellList(List<CellInfo> currentRowCellList) {
        this.currentRowCellList = currentRowCellList;
    }

    public void setMergeCellRanges(List<MergeCellRange> mergeCellRanges) {
        if (null != mergeCellRanges) {
            for (MergeCellRange mergeCellRange : mergeCellRanges) {
                this.putNewMergeCell(mergeCellRange);
            }
        }
    }

    public Map<String, MergeCellRange> getMergeCellRanges() {
        return this.mergeCellRanges;
    }

    public void putNewMergeCell(MergeCellRange range) {
        this.unrepeatedMergeCells.add(range);
        int firstRow = range.getFirstRow();
        int lastRow = range.getLastRow();
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = range.getFirstCol(); col <= range.getLastCol(); ++col) {
                String key = row + "_" + col;
                this.mergeCellRanges.put(key, range);
            }
        }
    }

    public MergeCellRange getMergeCellRange(int row, int col) {
        String key = row + "_" + col;
        return this.mergeCellRanges.get(key);
    }

    public List<MergeCellRange> getUnrepeatedMergeCells() {
        return this.unrepeatedMergeCells;
    }

    public SharedStringsTable getSharedStringsTable() {
        return this.sharedStringsTable;
    }

    public List<CellInfo> getCurrentRowCellList() {
        return this.currentRowCellList;
    }

    public CellInfo getCell(int colIndex) {
        if (colIndex >= this.getColSize()) {
            return null;
        }
        return this.currentRowCellList.get(colIndex);
    }

    public int getColSize() {
        return this.currentRowCellList.size();
    }

    public void addNewCell(CellInfo cell) {
        if (this.currentRowCellList.size() >= 1024) {
            return;
        }
        this.currentRowCellList.add(cell);
    }

    public void setSharedStringsTable(SharedStringsTable sharedStringsTable) {
        this.sharedStringsTable = sharedStringsTable;
    }

    public StylesTable getStylesTable() {
        return this.stylesTable;
    }

    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    public CellInfo getCurrentCell() {
        return this.currentCell;
    }

    public void setCurrentCell(CellInfo currentCell) {
        this.currentCell = currentCell;
    }
}

