/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.model.SharedStringsTable;

public class DateCellInfo
extends CellInfo {
    private Double rawValue;

    public DateCellInfo() {
        this.setCellDataType(CellDataType.DATE);
    }

    @Override
    public void initRawValue(SharedStringsTable sharedStringsTable) {
        if (!StringUtils.isEmpty((CharSequence)this.getCellOriginalValue())) {
            this.rawValue = Double.parseDouble(this.getCellOriginalValue());
        }
    }

    @Override
    protected String getFormateString() {
        if ("java.sql.Time".equals(this.getDataTypeClassName())) {
            Date date = DateUtil.getJavaDate((double)this.rawValue, (boolean)false);
            return DateUtils.DateTimeToString(date);
        }
        Date date = DateUtil.getJavaDate((double)this.rawValue, (boolean)false);
        return DateUtils.DateToString(date);
    }

    @Override
    protected CellInfo newInstance() {
        DateCellInfo cellInfo = new DateCellInfo();
        cellInfo.rawValue = this.rawValue;
        return cellInfo;
    }

    @Override
    public String getDataTypeClassName() {
        if (this.rawValue == null) {
            return null;
        }
        double digit = this.rawValue - (double)this.rawValue.longValue();
        if (digit > 0.0) {
            return "java.sql.Time";
        }
        return "java.util.Date";
    }

    @Override
    public Object getRawValue() {
        return this.rawValue;
    }

    @Override
    protected BigDecimal getNumericValue() throws ParseException {
        BigDecimal decimal = BigDecimal.valueOf(this.rawValue);
        decimal = decimal.setScale(15, RoundingMode.HALF_UP);
        return decimal;
    }

    @Override
    protected BigDecimal getBigInt() throws ParseException {
        return BigDecimal.valueOf(this.rawValue.longValue());
    }

    @Override
    protected Calendar getDateValue() throws ParseException {
        Calendar calendar = Calendar.getInstance();
        Date date = DateUtil.getJavaDate((double)this.rawValue, (boolean)false);
        calendar.setTime(date);
        return calendar;
    }

    @Override
    protected Long getLongValue() throws ParseException {
        return this.rawValue.longValue();
    }
}

