/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.util.ExcelDataUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import org.apache.poi.xssf.model.SharedStringsTable;

public class NumberCellInfo
extends CellInfo {
    private Double rawValue;
    private int dotIndex = -1;

    public NumberCellInfo() {
        this.setCellDataType(CellDataType.NUMBER);
    }

    @Override
    public Object getRawValue() {
        return this.rawValue;
    }

    @Override
    protected CellInfo newInstance() {
        NumberCellInfo cellInfo = new NumberCellInfo();
        cellInfo.rawValue = this.rawValue;
        cellInfo.dotIndex = this.dotIndex;
        return cellInfo;
    }

    @Override
    public void initRawValue(SharedStringsTable sharedStringsTable) {
        if (this.getCellOriginalValue().isEmpty()) {
            this.rawValue = null;
            return;
        }
        this.rawValue = Double.valueOf(this.getCellOriginalValue());
        this.dotIndex = this.getCellOriginalValue().lastIndexOf(46);
    }

    @Override
    protected String getFormateString() {
        if (this.getNumFmtString() != null) {
            return ExcelDataUtil.getNumberFormateString(this.rawValue, this.getNumFmtIndex(), this.getNumFmtString());
        }
        return this.getCellOriginalValue();
    }

    @Override
    public String getDataTypeClassName() {
        if (this.rawValue == null) {
            return null;
        }
        if (this.dotIndex != -1) {
            return this.dotIndex <= 16 ? "java.lang.Double" : "java.lang.String";
        }
        if (this.rawValue > 9.223372036854776E18 || this.rawValue < -9.223372036854776E18) {
            return "java.lang.String";
        }
        return "java.lang.Long";
    }

    @Override
    protected BigDecimal getNumericValue() throws ParseException {
        BigDecimal decimal = BigDecimal.valueOf(this.rawValue);
        if (decimal.scale() > 15) {
            decimal = decimal.setScale(15, RoundingMode.HALF_UP);
        }
        return decimal;
    }

    @Override
    protected BigDecimal getBigInt() throws ParseException {
        return BigDecimal.valueOf(this.rawValue.longValue());
    }

    @Override
    protected Long getLongValue() throws ParseException {
        return this.rawValue.longValue();
    }
}

