/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.IRowDataHandler;
import com.kingdee.bos.qing.data.exception.file.sax.InterruptedSAXException;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import shaded.com.google.common.collect.Maps;

public class ColumnNameRowHandler
implements IRowDataHandler<Map<Integer, String>> {
    private Map<Integer, String> colIndexAndNameMap = Maps.newHashMap();
    public static final int CAL_COL_READ_ROW_SIZE = 50;

    @Override
    public void handle(int rowNum, List<CellInfo> cellInfos) throws SAXException {
        if (rowNum <= 50) {
            int maxNotEmptyCol = 0;
            for (CellInfo cellInfo : cellInfos) {
                if (StringUtils.isEmpty((CharSequence)cellInfo.getStringValue())) continue;
                maxNotEmptyCol = Math.max(maxNotEmptyCol, cellInfo.getCol());
            }
            for (CellInfo cellInfo : cellInfos) {
                int thisCol = cellInfo.getCol();
                if (thisCol > maxNotEmptyCol) continue;
                this.handleCell(cellInfo, rowNum);
            }
            if (rowNum == 50) {
                throw new InterruptedSAXException();
            }
        }
    }

    private void handleCell(CellInfo cellInfo, int rowNum) {
        int thisCol = cellInfo.getCol();
        if (rowNum == 1) {
            if (StringUtils.isEmpty((CharSequence)cellInfo.getStringValue())) {
                this.colIndexAndNameMap.put(thisCol, this.getEmptyColName(thisCol));
            } else {
                this.colIndexAndNameMap.put(thisCol, this.getIndexedColName(cellInfo.getStringValue()));
            }
        } else {
            this.addEmptyCol(thisCol);
        }
    }

    private void addEmptyCol(int col) {
        if (!this.colIndexAndNameMap.containsKey(col)) {
            this.colIndexAndNameMap.put(col, this.getEmptyColName(col));
        }
    }

    @Override
    public Map<Integer, String> getHandleResult() {
        return this.colIndexAndNameMap;
    }

    private String getIndexedColName(String originalName) {
        int index = 0;
        String indexName = originalName;
        while (this.colIndexAndNameMap.containsValue(indexName)) {
            indexName = originalName + "_" + ++index;
        }
        return indexName.replaceAll("[\t\r\n]+", " ");
    }

    private String getEmptyColName(int thisCol) {
        return "column" + thisCol;
    }
}

