/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.domain.IFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import com.kingdee.bos.qing.data.exception.file.hssf.ExcelReadEndException;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import shaded.com.google.common.collect.Maps;
import shaded.com.google.common.collect.Sets;

public class XlsColumnTypeListener
implements XlsSheetContentsHandler {
    private IFileSourceDomain excelSourceDomain;
    private int limitRowCount = 0;
    private Map<Integer, String> colIndexAndNameMap = Maps.newHashMap();
    private Map<String, Set<String>> columnType = Maps.newHashMap();

    public Map<String, Set<String>> getColumnType() {
        return this.columnType;
    }

    @Override
    public void endRow(int thisRow) throws HSSFUserException {
        if (thisRow == this.limitRowCount) {
            throw new ExcelReadEndException();
        }
    }

    public XlsColumnTypeListener(IFileSourceDomain excelSourceDomain, int limitRowCount) {
        this.limitRowCount = limitRowCount;
        this.excelSourceDomain = excelSourceDomain;
    }

    @Override
    public void cell(int thisRow, int thisColumn, String comment) {
        if (thisRow == 0) {
            if (this.colIndexAndNameMap.containsValue(comment)) {
                Integer i = ThreadCache.getIndex() + 1;
                comment = comment + "_" + i;
                ThreadCache.setIndex(i);
            }
            this.colIndexAndNameMap.put(thisColumn, StringUtils.isBlank((CharSequence)comment) ? "column" + thisColumn : comment);
        } else if (thisRow > 0 && StringUtils.isNotBlank((CharSequence)comment) && thisColumn > -1) {
            String value = this.excelSourceDomain.calculateType2(comment);
            String colName = this.colIndexAndNameMap.get(thisColumn);
            Set<String> colValue = this.columnType.get(colName);
            if (colValue != null) {
                colValue.add(value);
            } else {
                HashSet set = Sets.newHashSet();
                set.add(value);
                this.columnType.put(colName, set);
            }
        }
    }
}

