/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.handler.AbortableFormatTrackingHSSFListener;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsColumnNameHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.LocaleUtil;

public class XlsListener
extends AbortableHSSFListener {
    private boolean outputFormulaValues = true;
    private SSTRecord sstRecord;
    private AbortableFormatTrackingHSSFListener formatListener;
    private int sheetIndex = -1;
    private BoundSheetRecord[] orderedBSRs;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private String targetName;
    private String originalName;
    private boolean isTargetSheet = false;
    private final HSSFDataFormatter _formatter;
    private final NumberFormat _defaultFormat;
    private XlsSheetContentsHandler handler;

    public void setFormatListener(AbortableFormatTrackingHSSFListener formatListener) {
        this.formatListener = formatListener;
    }

    public XlsListener(XlsSheetContentsHandler handler, String sheetName) {
        this.targetName = sheetName;
        this._formatter = new HSSFDataFormatter(LocaleUtil.getUserLocale());
        this._defaultFormat = NumberFormat.getInstance(LocaleUtil.getUserLocale());
        this.handler = handler;
    }

    public XlsListener(XlsSheetContentsHandler handler, String filename, String sheetName) throws IOException {
        this(handler, sheetName);
    }

    public short abortableProcessRecord(Record record) throws HSSFUserException {
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                ++this.sheetIndex;
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                }
                this.originalName = this.orderedBSRs[this.sheetIndex].getSheetname();
                this.isTargetSheet = this.targetName.equals(this.originalName);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                if (!this.isTargetSheet) break;
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                thisStr = "";
                break;
            }
            case 517: {
                if (!this.isTargetSheet) break;
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisStr = berec.getBooleanValue() + "";
                break;
            }
            case 6: {
                if (!this.isTargetSheet) break;
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                if (this.outputFormulaValues) {
                    if (Double.isNaN(frec.getValue())) {
                        this.outputNextStringRecord = true;
                        this.nextRow = frec.getRow();
                        this.nextColumn = frec.getColumn();
                        break;
                    }
                    thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                    break;
                }
                thisStr = '\"' + HSSFFormulaParser.toFormulaString(null, (Ptg[])frec.getParsedExpression()) + '\"';
                break;
            }
            case 519: {
                if (!this.isTargetSheet || !this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                thisStr = srec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                if (!this.isTargetSheet) break;
                LabelRecord lrec = (LabelRecord)record;
                thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                thisStr = lrec.getValue();
                break;
            }
            case 253: {
                if (!this.isTargetSheet) break;
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                if (this.sstRecord == null) {
                    thisStr = "";
                    break;
                }
                thisStr = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                break;
            }
            case 28: {
                if (!this.isTargetSheet) break;
                NoteRecord nrec = (NoteRecord)record;
                thisRow = nrec.getRow();
                thisColumn = nrec.getColumn();
                thisStr = "";
                break;
            }
            case 515: {
                if (!this.isTargetSheet) break;
                NumberRecord numrec = (NumberRecord)record;
                thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                thisStr = this.formatNumberDateCell(this.formatListener, (CellValueRecordInterface)numrec);
                break;
            }
            case 638: {
                if (!this.isTargetSheet) break;
                RKRecord rkrec = (RKRecord)record;
                thisRow = rkrec.getRow();
                thisColumn = rkrec.getColumn();
                thisStr = "";
                break;
            }
            case 512: {
                if (!this.isTargetSheet || !(this.handler instanceof XlsColumnNameHandler)) break;
                DimensionsRecord dimensionsRecord = (DimensionsRecord)record;
                for (int c = 0; c < dimensionsRecord.getLastCol(); ++c) {
                    ((XlsColumnNameHandler)this.handler).getColIndexAndNameMap().put(c, "column" + c);
                }
                break;
            }
        }
        if (this.isTargetSheet) {
            MissingCellDummyRecord mc;
            if (record instanceof MissingCellDummyRecord) {
                mc = (MissingCellDummyRecord)record;
                thisRow = mc.getRow();
                thisColumn = mc.getColumn();
                thisStr = "";
            }
            if (thisRow > -1 && thisColumn > -1) {
                this.handler.cell(thisRow, thisColumn, thisStr);
            }
            if (record instanceof LastCellOfRowDummyRecord && (thisRow = (mc = (LastCellOfRowDummyRecord)record).getRow()) > -1) {
                if (this.handler instanceof XlsColumnNameHandler) {
                    XlsColumnNameHandler xlsColumnNameHandler = (XlsColumnNameHandler)this.handler;
                    xlsColumnNameHandler.setCurrentMaxColSize(Math.max(xlsColumnNameHandler.getCurrentMaxColSize(), mc.getLastColumnNumber() + 1));
                }
                this.handler.endRow(thisRow);
            }
        }
        return 0;
    }

    public String formatNumberDateCell(AbortableFormatTrackingHSSFListener formatListener, CellValueRecordInterface cell) {
        double value;
        if (cell instanceof NumberRecord) {
            value = ((NumberRecord)cell).getValue();
        } else if (cell instanceof FormulaRecord) {
            value = ((FormulaRecord)cell).getValue();
        } else {
            throw new IllegalArgumentException("Unsupported CellValue Record passed in " + cell);
        }
        int formatIndex = formatListener.getFormatIndex(cell);
        String formatString = formatListener.getFormatString(cell);
        if (formatString == null) {
            return this._defaultFormat.format(value);
        }
        if (formatString.equals("m/d/yy")) {
            formatString = "yyyy/MM/dd HH:mm:ss";
        } else if (formatString.equals("m/d/yy h:mm")) {
            formatString = "yyyy/MM/dd HH:mm:ss";
        }
        if (formatIndex == 4) {
            return value + "";
        }
        if (!DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
            return String.valueOf(value);
        }
        return this._formatter.formatRawCellContents(value, formatIndex, formatString);
    }
}

