/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.ss.util.CellRangeAddress;
import shaded.com.google.common.collect.Maps;

public class XlsMergeCellsListener
implements HSSFListener {
    private int sheetIndex = -1;
    private BoundSheetRecord[] orderedBSRs;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private String targetName;
    private String originalName;
    private boolean isTargetSheet = false;
    private Map<String, String> mergeCells = Maps.newHashMap();

    public Map<String, String> getMergeCells() {
        return this.mergeCells;
    }

    public XlsMergeCellsListener(String sheetName) {
        this.targetName = sheetName;
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                ++this.sheetIndex;
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                }
                this.originalName = this.orderedBSRs[this.sheetIndex].getSheetname();
                this.isTargetSheet = this.targetName.equals(this.originalName);
                break;
            }
            case 252: {
                break;
            }
            case 229: {
                if (!this.isTargetSheet) break;
                MergeCellsRecord mr = (MergeCellsRecord)record;
                for (int region = 0; region < mr.getNumAreas(); ++region) {
                    CellRangeAddress address = mr.getAreaAt(region);
                    this.mergeCells.put(address.getFirstRow() + "-" + address.getFirstColumn(), address.getLastRow() + "-" + address.getLastColumn());
                }
                break;
            }
        }
    }
}

