/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.model.XmlParseDataModel;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlColIndexNameHandler
extends DefaultHandler {
    private List<String> levelList = new ArrayList<String>(10);
    private String[] xPath;
    Map<Integer, String> colIndexNameMap;
    private boolean isFieldNode = false;

    public XmlColIndexNameHandler(String[] xPath) {
        this.xPath = xPath;
    }

    public Map<Integer, String> getColIndexNameMap() {
        return this.colIndexNameMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.levelList.add(qName);
        if (this.colIndexNameMap == null) {
            this.colIndexNameMap = new HashMap<Integer, String>();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length).trim();
        if (!StringUtils.isEmpty((CharSequence)value)) {
            this.isFieldNode = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath) && this.isFieldNode && !this.colIndexNameMap.values().contains(qName)) {
            this.colIndexNameMap.put(this.colIndexNameMap.size(), qName);
        }
        if (!this.levelList.isEmpty()) {
            this.levelList.remove(this.levelList.size() - 1);
        }
        this.isFieldNode = false;
    }
}

