/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.source.file.model.XmlParseDataModel;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlTotalRowCountHandler
extends DefaultHandler {
    private List<String> levelList = new ArrayList<String>(10);
    private int rowCount;
    private int recordIndex = -1;
    private String[] xPath;
    private IRuntimeFilter iRuntimeFilter;
    private RuntimeEntity runtimeEntity;
    private Map<String, String> row = new HashMap<String, String>();
    private ResultContent rc = new ResultContent();
    private Map<Integer, String> colIndexNameMap;
    private XmlParseDataModel xmlParseDataModel;

    public XmlTotalRowCountHandler(RunningTimeParams params, String[] xPath, Map<Integer, String> colIndexNameMap, XmlParseDataModel xmlParseDataModel) {
        this.runtimeEntity = params.getRuntimeEntity();
        this.iRuntimeFilter = params.getRuntimeFilter();
        this.xPath = xPath;
        this.colIndexNameMap = colIndexNameMap;
        this.xmlParseDataModel = xmlParseDataModel;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.levelList.add(qName);
        if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath)) {
            this.recordIndex = this.colIndexNameMap.containsValue(qName) ? XmlParseDataModel.getKey(this.colIndexNameMap, qName) : -1;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.recordIndex > -1) {
            String nodeText = new String(ch, start, length);
            this.row.put(this.colIndexNameMap.get(this.recordIndex), nodeText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (XmlParseDataModel.isRecordWrapTag(this.levelList, this.xPath)) {
                List<Map<String, Object>> rowValueList = this.xmlParseDataModel.getFileSourceDomain().filterRow(this.rowCount + 1, this.row, this.iRuntimeFilter, this.runtimeEntity, this.rc);
                if (CollectionUtils.isNotEmpty(rowValueList)) {
                    this.rowCount += rowValueList.size();
                }
                this.row.clear();
            } else if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath)) {
                this.recordIndex = -1;
            }
        }
        finally {
            if (!this.levelList.isEmpty()) {
                this.levelList.remove(this.levelList.size() - 1);
            }
        }
    }
}

