/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.model;

import com.kingdee.bos.qing.data.domain.source.file.domain.IFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileAccessException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileNotFoundException;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFileModel {
    private IFileSourceDomain fileSourceDomain;
    protected Map<Integer, String> colIndexNameMap;
    protected Map<String, Set<String>> colTypeMap;
    private String path;
    private String fileName;
    protected Map<String, String> mergeCells;
    private int topN;
    private String tableName;
    protected List<String> tableNames;

    public IFileSourceDomain getFileSourceDomain() {
        return this.fileSourceDomain;
    }

    public void setFileSourceDomain(IFileSourceDomain fileSourceDomain) {
        this.fileSourceDomain = fileSourceDomain;
    }

    public abstract int getTotalRowCount(RunningTimeParams var1) throws AbstractSourceException;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMergeCells(Map<String, String> mergeCells) {
        this.mergeCells = mergeCells;
    }

    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    public String getPath() {
        return this.path;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public AbstractFileModel(String path) {
        this.path = path;
    }

    public AbstractFileModel(String path, String tableName) {
        this.path = path;
        this.tableName = tableName;
    }

    public AbstractFileModel(String path, String tableName, int topN) {
        this.path = path;
        this.tableName = tableName;
        this.topN = topN;
    }

    public abstract List<String> getTableNames() throws AbstractSourceException;

    public abstract Map<Integer, String> getColIndexNameMap() throws AbstractSourceException;

    public abstract Map<String, Set<String>> getColTypeMap() throws AbstractSourceException;

    public abstract String getColType(int var1) throws AbstractSourceException;

    public abstract ResultContent topNRow(RunningTimeParams var1, ProgressProcessor var2) throws AbstractSourceException, DataSourcePersistenceException;

    public void setColIndexNameMap(Map<Integer, String> colIndexNameMap) {
        this.colIndexNameMap = colIndexNameMap;
    }

    public void setColTypeMap(Map<String, Set<String>> colTypeMap) {
        this.colTypeMap = colTypeMap;
    }

    public String getFileLocalPath(String filePathName) throws FileSourceFileAccessException {
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)filePathName);
        if (!file.exists()) {
            file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)filePathName);
        }
        try {
            return file.getLocalFileSystemFile().getPath();
        }
        catch (FileNotFoundException e) {
            throw new FileSourceFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new FileSourceFileAccessException(e);
        }
    }

    public InputStream getFileInputStream(String filePathName) throws FileSourceFileAccessException {
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)filePathName);
        if (!file.exists()) {
            file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)filePathName);
        }
        try {
            return file.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new FileSourceFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new FileSourceFileAccessException(e);
        }
    }
}

