/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.model;

import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsColumnNameHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsColumnTypeListener;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsMergeCellsListener;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsRowCountHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandlerImpl;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetNameListener;
import com.kingdee.bos.qing.data.domain.source.file.model.AbstractFileModel;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.source.file.parser.Excel03Parser;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;

public class Excel03Model
extends AbstractFileModel {
    public Excel03Model(String path) {
        super(path);
    }

    public Excel03Model(String path, String tableName) {
        super(path, tableName);
    }

    public Excel03Model(String path, String tableName, int topN) {
        super(path, tableName, topN);
    }

    @Override
    public List<String> getTableNames() throws AbstractSourceException {
        if (null != this.tableNames) {
            return this.tableNames;
        }
        HSSFRequest request = new HSSFRequest();
        XlsSheetNameListener listener = new XlsSheetNameListener();
        request.addListener((HSSFListener)listener, (short)133);
        Excel03Parser.parse(this.getPath(), request);
        this.setTableNames(listener.getSheetNames());
        return this.tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, String> getColIndexNameMap() throws AbstractSourceException {
        if (null != this.colIndexNameMap) {
            return this.colIndexNameMap;
        }
        XlsColumnNameHandler handler = new XlsColumnNameHandler();
        InputStream in = this.getFileInputStream(this.getPath());
        try {
            Excel03Parser.parse(handler, in, this.getTableName());
            this.setColIndexNameMap(handler.getColIndexAndNameMap());
        }
        catch (AbstractDataSourceException e) {
            try {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return this.colIndexNameMap;
    }

    public Map<String, String> getMergeRegion() throws AbstractSourceException {
        if (null != this.mergeCells) {
            return this.mergeCells;
        }
        HSSFRequest request = new HSSFRequest();
        XlsMergeCellsListener mergeCellsListener = new XlsMergeCellsListener(this.getTableName());
        request.addListener((HSSFListener)mergeCellsListener, (short)133);
        request.addListener((HSSFListener)mergeCellsListener, (short)2057);
        request.addListener((HSSFListener)mergeCellsListener, (short)252);
        request.addListener((HSSFListener)mergeCellsListener, (short)229);
        Excel03Parser.parse(this.getPath(), request);
        this.setMergeCells(mergeCellsListener.getMergeCells());
        return this.mergeCells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<String>> getColTypeMap() throws AbstractSourceException {
        if (null != this.colTypeMap && this.colTypeMap.size() > 0) {
            return this.colTypeMap;
        }
        XlsColumnTypeListener handler = new XlsColumnTypeListener(this.getFileSourceDomain(), this.getTopN());
        InputStream in = this.getFileInputStream(this.getPath());
        try {
            Excel03Parser.parse(handler, in, this.getTableName());
            this.colTypeMap = handler.getColumnType();
        }
        catch (AbstractDataSourceException e) {
            try {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return this.colTypeMap;
    }

    @Override
    public String getColType(int colIndex) throws AbstractSourceException {
        String colName = this.getColIndexNameMap().get(colIndex);
        Set<String> colTypeSet = this.getColTypeMap().get(colName);
        return AbstractFileSourceDomain.caculateColumnType(colTypeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultContent topNRow(RunningTimeParams params, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException {
        XlsSheetContentsHandlerImpl handler = new XlsSheetContentsHandlerImpl(params, this.getColIndexNameMap(), this.getMergeRegion(), progressProcessor);
        InputStream in = this.getFileInputStream(this.getPath());
        try {
            Excel03Parser.parse(handler, in, this.getTableName());
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalRowCount(RunningTimeParams params) throws AbstractSourceException {
        XlsRowCountHandler handler = new XlsRowCountHandler(params, this.getMergeRegion(), this.getColIndexNameMap());
        InputStream in = this.getFileInputStream(this.getPath());
        try {
            Excel03Parser.parse(handler, in, this.getTableName());
        }
        catch (AbstractDataSourceException e) {
            try {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return handler.getRowCount();
    }
}

