/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.visitor;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.IDataSourceIterator;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.visitor.AbstractEntityDataSourceVisitor;
import com.kingdee.bos.qing.data.domain.visitor.AbstractEntityDirectModelDataIterator;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.DataSourceBizException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.QueryRowLimitException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.util.OutputDataTypeUtils;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceAccessBizException;
import com.kingdee.bos.qing.datasource.exception.DataSourceAccessException;
import com.kingdee.bos.qing.datasource.exception.DataSourceTooLargeException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.util.FilterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingleEntityDirectModelDataIterator
extends AbstractEntityDirectModelDataIterator {
    private IDataSourceIterator dataSourceIterator;
    protected RuntimeEntity runtimeEntity;
    private Map<String, Object> resultMap;

    public SingleEntityDirectModelDataIterator(AbstractEntityDataSourceVisitor abstractEntityDataSourceVisitor, QingContext qingContext, AbstractSource source, Entity entity, Set<String> whitePropertySet, String ownerId, MetaInfo metaInfo) {
        super(abstractEntityDataSourceVisitor, qingContext, source, entity, whitePropertySet, ownerId, metaInfo);
    }

    protected Entity getEntity() {
        return (Entity)this.entity;
    }

    @Override
    protected void innerInit(Map<String, Property> referenceDMPropertyMap, List<FilterItem> filterItems) throws AbstractDataSourceException, InterruptedException {
        AbstractDataSourceDomain sourceDomain = null;
        try {
            sourceDomain = SourceDomainFactory.getSourceDomain(this.source);
        }
        catch (UnSupportDataSourceException e) {
            throw new DataSourceAccessException((Throwable)e);
        }
        Entity newEntity = null;
        try {
            newEntity = this.getEntity().copy();
        }
        catch (ModelParseException e) {
            throw new DataSourceAccessException((Throwable)e);
        }
        List<FilterItem> dmEntityFilterItems = newEntity.getFilters();
        Map<String, Property> dmEntityPropertyMap = this.abstractEntityDataSourceVisitor.getDMEntityPropertyNameMap();
        if (dmEntityFilterItems != null && !dmEntityFilterItems.isEmpty()) {
            for (FilterItem dmEntityFilterItem : dmEntityFilterItems) {
                Set<String> dmEntityFilterItemPropertyDependenceNameSet;
                String dmEntityPropertyName;
                String dmEntityFilterItemPropertyName = dmEntityFilterItem.getProprety();
                Property dmEntityFilterItemProperty = dmEntityPropertyMap.get(dmEntityFilterItemPropertyName);
                if (dmEntityFilterItemProperty == null || referenceDMPropertyMap.containsKey(dmEntityPropertyName = dmEntityFilterItemProperty.getName())) continue;
                referenceDMPropertyMap.put(dmEntityPropertyName, dmEntityFilterItemProperty);
                if (!dmEntityFilterItemProperty.isCalculation() || (dmEntityFilterItemPropertyDependenceNameSet = dmEntityFilterItemProperty.getDependences()) == null || dmEntityFilterItemPropertyDependenceNameSet.isEmpty()) continue;
                for (String dmEntityFilterItemPropertyDependenceName : dmEntityFilterItemPropertyDependenceNameSet) {
                    if (referenceDMPropertyMap.containsKey(dmEntityFilterItemPropertyDependenceName)) continue;
                    Property dmEntityFilterItemPropertyDependence = dmEntityPropertyMap.get(dmEntityFilterItemPropertyDependenceName);
                    referenceDMPropertyMap.put(dmEntityFilterItemPropertyDependenceName, dmEntityFilterItemPropertyDependence);
                }
            }
        }
        dmEntityFilterItems = FilterItem.appendFilterItem(dmEntityFilterItems, filterItems, FilterItem.LogicOp.AND);
        newEntity.setFilters(dmEntityFilterItems);
        List<Property> dmEntityProperties = newEntity.getProperties();
        Iterator<Property> propertyIterator = dmEntityProperties.iterator();
        while (propertyIterator.hasNext()) {
            Property dmProperty = propertyIterator.next();
            String dmPropertyName = dmProperty.getName();
            if (referenceDMPropertyMap.containsKey(dmPropertyName)) continue;
            propertyIterator.remove();
        }
        this.runtimeEntity = sourceDomain.newRuntimeEntity(newEntity, null, this.whitePropertySet, this.source, this.qingContext, this.ownerId);
        try {
            RuntimeFilterUtil.Prediction prediction = sourceDomain.initRuntimeFilter(this.runtimeEntity);
            if (prediction.isAlwaysFalse()) {
                this.hasData = false;
            } else {
                IRuntimeFilter unpushDownableFilter = this.runtimeEntity.getUnPushdownableFilter();
                ArrayList<RuntimeProperty> unpushDownableProperties = new ArrayList<RuntimeProperty>();
                if (unpushDownableFilter != null) {
                    unpushDownableFilter.collectProperties(unpushDownableProperties);
                }
                int len = this.outputDMPropertyMap.size() + unpushDownableProperties.size();
                HashSet<String> outputPropertySetFromDataSource = new HashSet<String>(len);
                outputPropertySetFromDataSource.addAll(this.outputDMPropertyMap.keySet());
                for (RuntimeProperty runtimeProperty : unpushDownableProperties) {
                    outputPropertySetFromDataSource.add(runtimeProperty.getName());
                }
                this.runtimeEntity.init(outputPropertySetFromDataSource);
                this.dataSourceIterator = this.doInnerInit(sourceDomain);
            }
        }
        catch (DataSourceBizException e) {
            throw new DataSourceAccessBizException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (AbstractSourceException e) {
            throw new DataSourceAccessException(e.getMessage(), (Throwable)e);
        }
    }

    protected IDataSourceIterator doInnerInit(AbstractDataSourceDomain sourceDomain) throws AbstractSourceException {
        return sourceDomain.createDataSourceIterator(this.qingContext, this.runtimeEntity);
    }

    protected boolean hasNextRowImpl() throws AbstractDataSourceException, InterruptedException {
        if (!this.hasData) {
            return this.hasData;
        }
        try {
            Map<String, Object> oneRowData = null;
            while (this.dataSourceIterator.hasNext()) {
                oneRowData = this.dataSourceIterator.next();
                if (oneRowData == null) continue;
                Set outputDMPropertyNameSet = this.outputDMPropertyMap.entrySet();
                int columnSize = outputDMPropertyNameSet.size();
                this.resultMap = new HashMap<String, Object>(columnSize, 1.0f);
                for (Map.Entry outputDMPropertyEntry : outputDMPropertyNameSet) {
                    Property property = (Property)outputDMPropertyEntry.getValue();
                    String propertyName = property.getName();
                    Object value = oneRowData.get(property.getName());
                    value = OutputDataTypeUtils.handle(property.getOutputDataType(), value);
                    DSFieldKey dsFieldKey = new DSFieldKey(this.runtimeEntity.getName(), propertyName);
                    this.resultMap.put(dsFieldKey.toFullName(), value);
                }
                boolean allFilterMatch = true;
                if (this.unPushDownDSFilters != null && !this.unPushDownDSFilters.isEmpty()) {
                    for (AbstractUnderDSFilter unPushDownDSFilter : this.unPushDownDSFilters) {
                        Object paramObject;
                        if (FilterUtil.isMatchFilter((AbstractUnderDSFilter)unPushDownDSFilter, (Object)(paramObject = this.resultMap.get(unPushDownDSFilter.getField().toFullName())))) continue;
                        allFilterMatch = false;
                        break;
                    }
                }
                if (!allFilterMatch) continue;
                return true;
            }
            return false;
        }
        catch (DataSourceBizException e) {
            throw new DataSourceAccessBizException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (QueryRowLimitException e) {
            throw new DataSourceTooLargeException(e.getMessage());
        }
        catch (AbstractSourceException e) {
            throw new DataSourceAccessException(e.getMessage(), (Throwable)e);
        }
    }

    protected Map<String, Object> nextRowImpl() throws AbstractDataSourceException, InterruptedException {
        return this.resultMap;
    }

    protected void closeImpl() {
        if (this.dataSourceIterator != null) {
            this.dataSourceIterator.close();
        }
    }

    public void setAllFieldsNeeded(boolean isAllFieldsNeeded) {
    }
}

