/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.annotations.FieldPersistable;
import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntitySubView;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaHelper;
import com.kingdee.bos.qing.data.model.runtime.IPropertyFilter;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityColumnToRowProcess;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractEntity {
    private String name;
    private String alias;
    private String title;
    private String associateName;
    private List<Property> properties = new ArrayList<Property>();
    private List<Parild> parilds;
    private List<EntitySubView> subViews = null;
    private List<AbstractDMViewItem> viewItems = null;
    private List<FilterItem> filters = new ArrayList<FilterItem>();
    private boolean directModel = false;
    private Design design;
    private String parentName;
    private String unionLinkageName;
    private List<ColumnToRowProperty> columnToRowProperties;
    private String commentInfo;
    @FieldPersistable(value=false)
    private List<TreeProperty> treeNodeProperties = new ArrayList<TreeProperty>();
    private EntityErrorInfo errorInfo;
    private transient AbstractEntity parentEntity;

    public String getCommentInfo() {
        return this.commentInfo;
    }

    public void setCommentInfo(String commentInfo) {
        this.commentInfo = commentInfo;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public abstract EntityType getEntityType();

    public AbstractEntity getParentEntity() {
        return this.parentEntity;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setParentEntity(AbstractEntity parentEntity) {
        this.parentEntity = parentEntity;
    }

    public void setTreeNodeProperties(List<TreeProperty> treeNodeProperties) {
        this.treeNodeProperties = treeNodeProperties;
    }

    public List<TreeProperty> getTreeNodeProperties() {
        return this.treeNodeProperties;
    }

    public TreeProperty getTreeProperty(String treePropName) {
        for (TreeProperty treeProperty : this.treeNodeProperties) {
            if (!treeProperty.getName().equals(treePropName)) continue;
            return treeProperty;
        }
        return null;
    }

    public final String getAssociateName() {
        return this.associateName;
    }

    public final void setAssociateName(String associateName) {
        this.associateName = associateName;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String alias) {
        this.alias = alias;
    }

    public final List<Property> getProperties() {
        return this.properties;
    }

    public final void setProperties(List<Property> properties) {
        this.properties = null == properties ? new ArrayList<Property>() : properties;
    }

    public EntityErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public final List<Parild> getParilds() {
        return this.parilds;
    }

    public final void setParilds(List<Parild> parilds) {
        this.parilds = parilds;
    }

    public List<EntitySubView> getSubViews() {
        return this.subViews;
    }

    public void setSubViews(List<EntitySubView> subViews) {
        this.subViews = subViews;
    }

    public void addSubView(EntitySubView subView) {
        if (this.subViews == null) {
            this.subViews = new ArrayList<EntitySubView>();
        }
        this.subViews.add(subView);
    }

    public void removeSubView(EntitySubView removeDMEntitySubView) {
        if (this.subViews != null) {
            this.subViews.remove(removeDMEntitySubView);
        }
    }

    public List<AbstractDMViewItem> getViewItems() {
        return this.viewItems;
    }

    public void setViewItems(List<AbstractDMViewItem> viewItems) {
        this.viewItems = viewItems;
    }

    public void removeViewItem(AbstractDMViewItem removeDMEntitySubView) {
        if (this.viewItems != null) {
            this.viewItems.remove(removeDMEntitySubView);
        }
    }

    public void addViewItem(AbstractDMViewItem removeDMEntitySubView) {
        if (this.viewItems == null) {
            this.viewItems = new ArrayList<AbstractDMViewItem>();
        }
        this.viewItems.add(removeDMEntitySubView);
    }

    public void addViewItems(List<? extends AbstractDMViewItem> removeDMEntitySubViews) {
        if (this.viewItems == null) {
            this.viewItems = new ArrayList<AbstractDMViewItem>();
        }
        this.viewItems.addAll(removeDMEntitySubViews);
    }

    public final List<FilterItem> getFilters() {
        return this.filters;
    }

    public final void setFilters(List<FilterItem> filters) {
        this.filters = null == filters ? new ArrayList<FilterItem>() : filters;
    }

    public boolean isUnion() {
        return false;
    }

    public AbstractEntity getTopParent() {
        AbstractEntity temp = this;
        while (null != temp.getParentEntity()) {
            temp = temp.getParentEntity();
        }
        return temp;
    }

    public boolean hasDirectModel() {
        return this.directModel;
    }

    public boolean hasExtractModel() {
        return !this.directModel;
    }

    public void setDirectModel(boolean directModel) {
        this.directModel = directModel;
    }

    protected boolean isPropertyExist() {
        return null != this.properties && !this.properties.isEmpty();
    }

    protected boolean existNullAttributeValue(String[] attrs) {
        for (String attr : attrs) {
            if (!StringUtils.isEmpty((CharSequence)attr)) continue;
            return true;
        }
        return false;
    }

    public final String getParentName() {
        return this.parentName;
    }

    public String getUnionLinkageName() {
        return this.unionLinkageName;
    }

    public void setUnionLinkageName(String unionLinkageName) {
        this.unionLinkageName = unionLinkageName;
    }

    public final void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Design getDesign() {
        return this.design;
    }

    protected boolean isRealDataEntity() {
        return false;
    }

    public Property getPropertyByAssociateName(String propAssociateName) {
        for (Property prop : this.properties) {
            if (!prop.getAssociateName().equals(propAssociateName)) continue;
            return prop;
        }
        return null;
    }

    public Property getProperty(String propName) {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        return null;
    }

    public Property getProperties(IPropertyFilter filter) {
        for (Property prop : this.properties) {
            if (!filter.doFilter(prop)) continue;
            return prop;
        }
        return null;
    }

    public Element toXml() {
        Element element;
        Element node = new Element("Entity");
        node.setAttribute("name", this.name);
        node.setAttribute("alias", this.alias);
        node.setAttribute("associateName", this.associateName);
        if (this.parentName != null) {
            node.setAttribute("parentName", this.parentName);
        }
        if (this.design != null) {
            Element nodeDesign = this.design.toXml();
            nodeDesign.setName("Design");
            node.addContent((Content)nodeDesign);
        }
        Element nodeProperties = new Element("Properties");
        for (Property property : this.properties) {
            if (property.isInvalidForParent() || !property.isDataModelSupported()) continue;
            nodeProperties.addContent((Content)property.toXml());
        }
        node.addContent((Content)nodeProperties);
        if (this.parilds != null) {
            Element nodeParilds = new Element("Parilds");
            for (Parild parild : this.parilds) {
                nodeParilds.addContent((Content)parild.toXml());
            }
            node.addContent((Content)nodeParilds);
        }
        if (this.subViews != null && this.subViews.size() > 0) {
            Element subViews = new Element("EntitySubViews");
            for (EntitySubView subView : this.subViews) {
                element = subView.toXml();
                if (element == null) continue;
                subViews.addContent((Content)element);
            }
            node.addContent((Content)subViews);
        }
        if (this.viewItems != null && this.viewItems.size() > 0) {
            Element viewItems = new Element("ViewItems");
            for (AbstractDMViewItem item : this.viewItems) {
                element = item.toXml();
                if (element == null) continue;
                viewItems.addContent((Content)element);
            }
            node.addContent((Content)viewItems);
        }
        if (this.filters != null && this.filters.size() > 0) {
            Element nodeFilters = new Element("Filters");
            for (FilterItem filter : this.filters) {
                nodeFilters.addContent((Content)filter.toXml());
            }
            node.addContent((Content)nodeFilters);
        }
        if (CollectionUtils.isNotEmpty(this.columnToRowProperties)) {
            Element nodeColumnToRowProperties = new Element("ColumnToRowProperties");
            for (ColumnToRowProperty columnToRowProperty : this.columnToRowProperties) {
                nodeColumnToRowProperties.addContent((Content)columnToRowProperty.toXml());
            }
            node.addContent((Content)nodeColumnToRowProperties);
        }
        node.setAttribute("directModel", String.valueOf(this.directModel));
        this.subToXml(node);
        return node;
    }

    public void setErrorInfo(EntityErrorInfo entityErrorInfo) {
        if (entityErrorInfo.isHigherPriority(this.errorInfo)) {
            this.errorInfo = entityErrorInfo;
        }
    }

    public final void fromXml(Element node, Set<String> unknownSourceNames) throws ModelParseException {
        String directModelString;
        Element nodeFilters;
        Element nodeViewItems;
        Element nodeEntitySubViews;
        Element nodeParilds;
        this.name = node.getAttributeValue("name");
        this.alias = node.getAttributeValue("alias");
        this.associateName = node.getAttributeValue("associateName");
        if (this.name == null || this.alias == null) {
            throw new ModelParseException("Entity's name and alias must be not null.");
        }
        if (this.isRealDataEntity() && this.associateName == null) {
            throw new ModelParseException("Entity's associateName must be not null.");
        }
        this.parentName = node.getAttributeValue("parentName");
        this.attrFromRootElement(node);
        Element nodeDesign = node.getChild("Design");
        if (nodeDesign != null) {
            this.design = new Design();
            this.design.fromXml(nodeDesign);
        }
        boolean hasAnyCalculation = false;
        Element nodeProperties = node.getChild("Properties");
        this.properties = new ArrayList<Property>(nodeProperties.getChildren().size());
        for (Element nodeProperty : nodeProperties.getChildren()) {
            Property property = new Property();
            property.fromXml(nodeProperty);
            this.properties.add(property);
            if (hasAnyCalculation || !property.isCalculation()) continue;
            hasAnyCalculation = true;
        }
        Element nodeColumnToRowProperties = node.getChild("ColumnToRowProperties");
        if (nodeColumnToRowProperties != null) {
            this.columnToRowProperties = new ArrayList<ColumnToRowProperty>(10);
            for (Element nodeColumnToRowProperty : nodeColumnToRowProperties.getChildren()) {
                ColumnToRowProperty columnToRowProperty = new ColumnToRowProperty();
                columnToRowProperty.fromXml(nodeColumnToRowProperty);
                this.columnToRowProperties.add(columnToRowProperty);
            }
        }
        if (hasAnyCalculation) {
            if (this.columnToRowProperties != null) {
                ArrayList<Property> allProperties = new ArrayList<Property>();
                allProperties.addAll(this.properties);
                FixEntityColumnToRowProcess.processProperties(this.columnToRowProperties, allProperties);
                FormulaHelper.handleAll(allProperties);
            } else {
                FormulaHelper.handleAll(this.properties);
            }
        }
        if ((nodeParilds = node.getChild("Parilds")) != null) {
            this.parilds = new ArrayList<Parild>(nodeParilds.getChildren().size());
            for (Element nodeParild : nodeParilds.getChildren()) {
                Parild parild = new Parild();
                parild.fromXml(nodeParild);
                this.parilds.add(parild);
            }
        }
        if ((nodeEntitySubViews = node.getChild("EntitySubViews")) != null) {
            this.subViews = new ArrayList<EntitySubView>(nodeEntitySubViews.getChildren().size());
            for (Element nodeEntitySubView : nodeEntitySubViews.getChildren()) {
                EntitySubView entitySubView = new EntitySubView();
                entitySubView.fromXml(nodeEntitySubView);
                this.subViews.add(entitySubView);
            }
        }
        if ((nodeViewItems = node.getChild("ViewItems")) != null) {
            this.viewItems = new ArrayList<AbstractDMViewItem>(nodeViewItems.getChildren().size());
            for (Element nodeitViewItem : nodeViewItems.getChildren()) {
                AbstractDMViewItem abstractViewItem = AbstractDMViewItem.create(nodeitViewItem);
                abstractViewItem.fromXml(nodeitViewItem);
                this.viewItems.add(abstractViewItem);
            }
        }
        if ((nodeFilters = node.getChild("Filters")) != null) {
            this.filters = new ArrayList<FilterItem>(nodeFilters.getChildren().size());
            for (Element nodeFilter : nodeFilters.getChildren()) {
                FilterItem fileter = new FilterItem();
                fileter.fromXml(nodeFilter);
                this.filters.add(fileter);
            }
        }
        this.directModel = (directModelString = node.getAttributeValue("directModel")) == null ? false : Boolean.parseBoolean(directModelString);
        this.subFromXml(node, unknownSourceNames);
    }

    protected void attrFromRootElement(Element rootNode) {
    }

    protected abstract void subToXml(Element var1);

    protected abstract void subFromXml(Element var1, Set<String> var2) throws ModelParseException;

    public abstract boolean isUnionUnitEntity();

    public boolean isIgnore(Set<String> unknownSourceNames) {
        return false;
    }

    public boolean isInvalid() {
        return false;
    }

    public List<ColumnToRowProperty> getColumnToRowProperties() {
        return this.columnToRowProperties;
    }

    public void setColumnToRowProperties(List<ColumnToRowProperty> columnToRowProperties) {
        this.columnToRowProperties = columnToRowProperties;
    }

    public static AbstractEntity create(Element node) {
        if (node.getName().equalsIgnoreCase("UnionEntity")) {
            return new UnionEntity();
        }
        return new Entity();
    }

    public static class Design {
        private int x;
        private int y;
        private int width;
        private int height;

        public Element toXml() {
            Element node = new Element("Node");
            node.setAttribute("x", Integer.toString(this.x));
            node.setAttribute("y", Integer.toString(this.y));
            node.setAttribute("width", Integer.toString(this.width));
            node.setAttribute("height", Integer.toString(this.height));
            return node;
        }

        public void fromXml(Element node) throws ModelParseException {
            try {
                this.x = Integer.parseInt(node.getAttributeValue("x"));
                this.y = Integer.parseInt(node.getAttributeValue("y"));
                this.width = Integer.parseInt(node.getAttributeValue("width"));
                this.height = Integer.parseInt(node.getAttributeValue("height"));
            }
            catch (NumberFormatException ex) {
                throw new ModelParseException("Parse Entity's designing rectange error.", (Throwable)ex);
            }
        }
    }
}

