/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ColumnToRowPropertyItem {
    private String fieldName;
    private List<String> propertyValues;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<String> getPropertyValues() {
        return this.propertyValues;
    }

    public Element toXml() {
        Element columnToRowPropertyItemNode = new Element("ColumnToRowPropertyItem");
        columnToRowPropertyItemNode.setAttribute("fieldName", this.fieldName);
        if (CollectionUtils.isNotEmpty(this.propertyValues)) {
            Element propertyValuesNode = new Element("PropertyValues");
            for (String propertyValue : this.propertyValues) {
                Element propertyValueNode = new Element("PropertyValue");
                if (propertyValue != null) {
                    propertyValueNode.setAttribute("value", propertyValue);
                }
                propertyValuesNode.addContent((Content)propertyValueNode);
            }
            columnToRowPropertyItemNode.addContent((Content)propertyValuesNode);
        }
        return columnToRowPropertyItemNode;
    }

    public void fromXml(Element columnToRowPropertyItemElement) throws ModelParseException {
        this.fieldName = columnToRowPropertyItemElement.getAttributeValue("fieldName");
        Element propertyValuesElement = columnToRowPropertyItemElement.getChild("PropertyValues");
        List propertyValuesChildren = propertyValuesElement.getChildren();
        this.propertyValues = new ArrayList<String>(propertyValuesChildren.size());
        for (Element propertyValueElement : propertyValuesChildren) {
            String value = propertyValueElement.getAttributeValue("value");
            this.propertyValues.add(value);
        }
    }

    public String toString() {
        StringBuilder sPropertyValues = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.propertyValues)) {
            sPropertyValues.append("{").append(StringUtils.join((char)',', this.propertyValues)).append("}");
        }
        return "ColumnToRowPropertyItem{fieldName=" + this.fieldName + ", propertyValues=" + sPropertyValues + "}";
    }
}

