/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientClosedListenerAdapter;
import com.kingdee.bos.qing.common.framework.manage.ClientStateListenerMgr;
import com.kingdee.bos.qing.common.framework.manage.IClientClosedListener;
import com.kingdee.bos.qing.common.thread.DelayedRunnable;
import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class DesignObjectGlobalJvmCache
implements DelayedRunnable {
    private static final int MAX_CACHE_SIZE = 100;
    private static final long EXPIRE_TIME = 180000L;
    private String clientId;
    private long lastUpdateTime = System.currentTimeMillis();
    private Map<String, DesigntimeDataObject> entityDesignObjMap = new HashMap<String, DesigntimeDataObject>();
    private static Map<String, DesignObjectGlobalJvmCache> designObjectCacheMap;
    private static Map<String, DesignObjectGlobalJvmCache> weakDesignObjectCacheMap;
    private volatile boolean closed = false;

    private DesignObjectGlobalJvmCache(String clientId) {
        this.clientId = clientId;
        GlobalScheduledExecutor.schedule((DelayedRunnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCache() {
        Map<String, DesigntimeDataObject> map = this.entityDesignObjMap;
        synchronized (map) {
            this.closed = true;
            this.entityDesignObjMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesigntimeDataObject getDesignDataObj(String entityNumber) {
        this.lastUpdateTime = System.currentTimeMillis();
        Map<String, DesigntimeDataObject> map = this.entityDesignObjMap;
        synchronized (map) {
            return this.entityDesignObjMap.get(entityNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheDesignDataObj(String entityNumber, DesigntimeDataObject designtimeDataObject) {
        Map<String, DesigntimeDataObject> map = this.entityDesignObjMap;
        synchronized (map) {
            if (this.closed) {
                return;
            }
            this.entityDesignObjMap.put(entityNumber, designtimeDataObject);
        }
    }

    public static void cacheDesignDataObj(String clientId, String entityNumber, DesigntimeDataObject designtimeDataObject) {
        DesignObjectGlobalJvmCache cache = DesignObjectGlobalJvmCache.getDesignObjectCache(clientId);
        cache.cacheDesignDataObj(entityNumber, designtimeDataObject);
    }

    public static DesigntimeDataObject getDesignDataObj(String clientId, String entityNumber) {
        DesignObjectGlobalJvmCache cache = DesignObjectGlobalJvmCache.getDesignObjectCache(clientId);
        return cache.getDesignDataObj(entityNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DesignObjectGlobalJvmCache getDesignObjectCache(String clientId) {
        DesignObjectGlobalJvmCache cache = null;
        Map<String, DesignObjectGlobalJvmCache> map = designObjectCacheMap;
        synchronized (map) {
            cache = designObjectCacheMap.get(clientId);
            if (null == cache) {
                cache = weakDesignObjectCacheMap.get(clientId);
            }
            if (null != cache) {
                designObjectCacheMap.put(clientId, cache);
            } else {
                cache = new DesignObjectGlobalJvmCache(clientId);
                int currentSize = designObjectCacheMap.size();
                if (currentSize < 100) {
                    designObjectCacheMap.put(clientId, cache);
                } else {
                    weakDesignObjectCacheMap.putAll(designObjectCacheMap);
                    designObjectCacheMap.clear();
                    designObjectCacheMap.put(clientId, cache);
                }
            }
        }
        return cache;
    }

    public long getDelayTime() {
        return this.lastUpdateTime + 180000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long duration = System.currentTimeMillis() - this.lastUpdateTime;
        if (duration < 180000L && !this.closed) {
            GlobalScheduledExecutor.schedule((DelayedRunnable)this);
            return;
        }
        Map<String, DesignObjectGlobalJvmCache> map = designObjectCacheMap;
        synchronized (map) {
            designObjectCacheMap.remove(this.clientId);
        }
        this.closeCache();
    }

    static {
        ClientStateListenerMgr.getInstance().registerListener((IClientClosedListener)new DesignObjectCacheClientCloseListener());
        designObjectCacheMap = new HashMap<String, DesignObjectGlobalJvmCache>(100);
        weakDesignObjectCacheMap = new WeakHashMap<String, DesignObjectGlobalJvmCache>();
    }

    private static class DesignObjectCacheClientCloseListener
    extends ClientClosedListenerAdapter {
        private DesignObjectCacheClientCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClientClosed(QingContext qingContext, String clientId) {
            Map map = designObjectCacheMap;
            synchronized (map) {
                DesignObjectGlobalJvmCache cache = (DesignObjectGlobalJvmCache)designObjectCacheMap.remove(clientId);
                if (null != cache) {
                    cache.closeCache();
                }
            }
        }

        public String getListenerKey() {
            return DesignObjectGlobalJvmCache.class.getName();
        }
    }
}

