/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class EntitySubView {
    private String name;
    private String alias;
    private ViewType viewType = ViewType.TABLE;
    private List<EntitySubView> subViews;
    private List<AbstractDMViewItem> viewItems;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public int getDSSubViewType() {
        switch (this.viewType) {
            case TABLE: {
                return 0;
            }
            case DIMENSION: {
                return 2;
            }
            case FLEX_FIELD: {
                return 1;
            }
        }
        return 0;
    }

    public void setSubViews(List<EntitySubView> subViews) {
        this.subViews = subViews;
    }

    public List<EntitySubView> getSubViews() {
        return this.subViews;
    }

    public void addSubView(EntitySubView newEntitySubView) {
        if (this.subViews == null) {
            this.subViews = new ArrayList<EntitySubView>();
        }
        this.subViews.add(newEntitySubView);
    }

    public void removeSubView(EntitySubView removeDMEntitySubView) {
        if (this.subViews != null) {
            this.subViews.remove(removeDMEntitySubView);
        }
    }

    public void removeViewItem(AbstractDMViewItem removeDMEntitySubView) {
        if (this.viewItems != null) {
            this.viewItems.remove(removeDMEntitySubView);
        }
    }

    public void addViewItem(AbstractDMViewItem addDMViewItem) {
        if (this.viewItems == null) {
            this.viewItems = new ArrayList<AbstractDMViewItem>();
        }
        this.viewItems.add(addDMViewItem);
    }

    public List<AbstractDMViewItem> getViewItems() {
        return this.viewItems;
    }

    public void setViewItems(List<AbstractDMViewItem> viewItems) {
        this.viewItems = viewItems;
    }

    public Element toXml() {
        Element element;
        Element node = new Element("SubView");
        node.setAttribute("name", this.name);
        node.setAttribute("alias", this.alias);
        node.setAttribute("subViewType", (Object)((Object)this.viewType) + "");
        if (this.subViews != null && this.subViews.size() > 0) {
            Element subViews = new Element("EntitySubViews");
            for (EntitySubView subView : this.subViews) {
                element = subView.toXml();
                if (element == null) continue;
                subViews.addContent((Content)element);
            }
            node.addContent((Content)subViews);
        }
        if (this.viewItems != null && this.viewItems.size() > 0) {
            Element viewItems = new Element("ViewItems");
            for (AbstractDMViewItem item : this.viewItems) {
                element = item.toXml();
                if (element == null) continue;
                viewItems.addContent((Content)element);
            }
            node.addContent((Content)viewItems);
        }
        return node;
    }

    public void fromXml(Element node) {
        Element nodeViewItems;
        this.name = node.getAttributeValue("name");
        this.alias = node.getAttributeValue("alias");
        String subViewTypeString = node.getAttributeValue("subViewType");
        this.viewType = subViewTypeString == null ? ViewType.TABLE : ViewType.valueOf(subViewTypeString);
        node.setAttribute("subViewType", this.viewType.toString());
        Element nodeEntitySubViews = node.getChild("EntitySubViews");
        if (nodeEntitySubViews != null) {
            Iterator itEntitySubViews = nodeEntitySubViews.getChildren().iterator();
            this.subViews = new ArrayList<EntitySubView>(nodeEntitySubViews.getChildren().size());
            while (itEntitySubViews.hasNext()) {
                Element nodeEntitySubView = (Element)itEntitySubViews.next();
                EntitySubView entitySubView = new EntitySubView();
                entitySubView.fromXml(nodeEntitySubView);
                this.subViews.add(entitySubView);
            }
        }
        if ((nodeViewItems = node.getChild("ViewItems")) != null) {
            Iterator itViewItems = nodeViewItems.getChildren().iterator();
            this.viewItems = new ArrayList<AbstractDMViewItem>(nodeViewItems.getChildren().size());
            while (itViewItems.hasNext()) {
                Element nodeitViewItem = (Element)itViewItems.next();
                AbstractDMViewItem abstractViewItem = AbstractDMViewItem.create(nodeitViewItem);
                abstractViewItem.fromXml(nodeitViewItem);
                this.viewItems.add(abstractViewItem);
            }
        }
    }

    public static enum ViewType {
        TABLE,
        FLEX_FIELD,
        DIMENSION;

    }
}

