/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.EnumValue;
import com.kingdee.bos.qing.data.model.designtime.ForeignKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class Property {
    private String name;
    private String associateName;
    private String alias;
    private DesigningDataType dataType;
    private DesigningDataType appointedDataType;
    private String format;
    private boolean hide;
    private boolean isVoidEnumProp;
    private boolean hideInDataModeling;
    private ForeignKey foreignKey;
    private Map<String, String> enumValue;
    private String commentInfo;
    private String group;
    private String formula;
    private Boolean isFormulaInvalid;
    private String relatedBaseProperty = "";
    private boolean _invalid4Union = false;
    private boolean isInvalidForParent = false;
    private boolean hasChild = false;
    private boolean isNotExisted = false;
    private transient Map<String, Object> extensionProps = new HashMap<String, Object>();
    private transient IExpr _expr;
    private transient Set<String> _dependences;
    private transient Property parent;

    public String getCommentInfo() {
        return this.commentInfo;
    }

    public void setCommentInfo(String commentInfo) {
        this.commentInfo = commentInfo;
    }

    public void addExtensionData(String key, Object value) {
        this.extensionProps.put(key, value);
    }

    public Map<String, Object> getExtensionProps() {
        return this.extensionProps;
    }

    public boolean isHasChild() {
        return this.hasChild;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    public boolean isNotExisted() {
        return this.isNotExisted;
    }

    public void setNotExisted(boolean notExisted) {
        this.isNotExisted = notExisted;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isInvalid4Union() {
        return this._invalid4Union;
    }

    public void setInvalid4Union(boolean _invalid4Union) {
        this._invalid4Union = _invalid4Union;
    }

    public boolean isHideInDataModeling() {
        return this.hideInDataModeling;
    }

    public void setHideInDataModeling(boolean hideInDataModeling) {
        this.hideInDataModeling = hideInDataModeling;
    }

    public boolean isInvalidForParent() {
        return this.isInvalidForParent;
    }

    public void setInvalidForParent(boolean invalidForParent) {
        this.isInvalidForParent = invalidForParent;
    }

    public <T> T getExtensionValue(String key, Class<T> type) {
        Object value = this.extensionProps.get(key);
        if (null == value) {
            return null;
        }
        return type.cast(value);
    }

    public boolean isPkProperty() {
        Object value = this.extensionProps.get("isPkProperty");
        return value == null ? false : (Boolean)value;
    }

    public boolean isParentPkProperty() {
        Object value = this.extensionProps.get("isParentPkProperty");
        return value == null ? false : (Boolean)value;
    }

    public boolean isSelectProperty() {
        Object value = this.extensionProps.get("isInputProp");
        return value == null ? true : (Boolean)value;
    }

    public boolean isOutputProperty() {
        Object value = this.extensionProps.get("isOutPutProp");
        return value == null ? true : (Boolean)value;
    }

    public boolean isDataModelSupported() {
        Object value = this.extensionProps.get("isDataModelSupported");
        return value == null ? true : (Boolean)value;
    }

    public Property getParent() {
        return this.parent;
    }

    public void setParent(Property parent) {
        this.parent = parent;
    }

    public Object getMetaField() {
        return this.extensionProps.get("metaField");
    }

    public String getAssociateName() {
        return this.associateName;
    }

    public void setAssociateName(String associateName) {
        this.associateName = associateName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DesigningDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DesigningDataType dataType) {
        this.dataType = dataType;
    }

    public DesigningDataType getAppointedDataType() {
        return this.appointedDataType;
    }

    public void setAppointedDataType(DesigningDataType dataType) {
        this.appointedDataType = dataType;
    }

    public DesigningDataType getOutputDataType() {
        return this.appointedDataType == null ? this.dataType : this.appointedDataType;
    }

    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(ForeignKey foreignKey) {
        this.foreignKey = foreignKey;
    }

    public String getFormatString() {
        return this.format;
    }

    public void setFormatString(String format) {
        this.format = format;
    }

    public String getRelatedBaseProperty() {
        return this.relatedBaseProperty;
    }

    public void setRelatedBaseProperty(String basePropRelated) {
        this.relatedBaseProperty = null != basePropRelated ? basePropRelated : "";
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean isHide) {
        this.hide = isHide;
    }

    public Map<String, String> getEnumValue() {
        return this.enumValue;
    }

    public void setEnumValue(Map<String, String> enumValue) {
        this.enumValue = enumValue;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean isFormulaInvalid() {
        return this.isFormulaInvalid != null && this.isFormulaInvalid != false;
    }

    public void setFormulaInvalid(boolean isInvalid) {
        this.isFormulaInvalid = isInvalid ? Boolean.TRUE : null;
    }

    public IExpr getParsedFormula() {
        return this._expr;
    }

    public void setParsedFormula(IExpr expr) {
        this._expr = expr;
    }

    public Set<String> getDependences() {
        return this._dependences;
    }

    public void setDependences(Set<String> dependences) {
        if (this._dependences == null) {
            this._dependences = new HashSet<String>();
        }
        this._dependences.addAll(dependences);
    }

    public boolean isCalculation() {
        return this.formula != null;
    }

    public boolean isValidCalculation() {
        return this._expr != null && !this.isFormulaInvalid();
    }

    public Element toXml() {
        Element node = new Element("Property");
        node.setAttribute("name", this.name);
        node.setAttribute("associateName", this.associateName);
        node.setAttribute("alias", this.alias);
        node.setAttribute("dataType", this.dataType.toPersistance());
        if (this.group != null) {
            node.setAttribute("group", this.group);
        }
        if (this.appointedDataType != null) {
            node.setAttribute("appointedDataType", this.appointedDataType.toPersistance());
        }
        if (this.format != null) {
            node.setAttribute("format", this.format);
        }
        if (this.isHide()) {
            node.setAttribute("hide", "true");
        }
        if (this.formula != null) {
            node.setAttribute("formula", this.formula);
        }
        if (!this.relatedBaseProperty.isEmpty()) {
            node.setAttribute("propertyRelated", this.relatedBaseProperty);
        }
        if (this.foreignKey != null) {
            Element fkInfoNode = this.foreignKey.toXml();
            node.addContent((Content)fkInfoNode);
        }
        if (this.enumValue != null) {
            EnumValue eValue = new EnumValue(this.enumValue);
            Element enumValueNode = eValue.toXml();
            node.addContent((Content)enumValueNode);
        }
        node.setAttribute("hideInDataModeling", String.valueOf(this.hideInDataModeling));
        return node;
    }

    public void fromXml(Element node) throws ModelParseException {
        Element enumValueNode;
        this.name = node.getAttributeValue("name");
        this.associateName = node.getAttributeValue("associateName");
        if (this.associateName == null) {
            this.associateName = this.name;
        }
        this.alias = node.getAttributeValue("alias");
        if (this.name == null || this.alias == null) {
            throw new ModelParseException("Property's name and alias must be not null.");
        }
        String group = node.getAttributeValue("group");
        if (group != null) {
            this.group = group;
        }
        this.dataType = DesigningDataType.fromPersistance(node.getAttributeValue("dataType"));
        String adt = node.getAttributeValue("appointedDataType");
        if (adt != null) {
            this.appointedDataType = DesigningDataType.fromPersistance(adt);
        }
        this.format = node.getAttributeValue("format");
        if ("true".equals(node.getAttributeValue("hide"))) {
            this.setHide(true);
        }
        if ("true".equals(node.getAttributeValue("hideInDataModeling"))) {
            this.setHideInDataModeling(true);
        }
        this.formula = node.getAttributeValue("formula");
        Element fKNode = node.getChild("ForeignKey");
        if (fKNode != null) {
            this.foreignKey = new ForeignKey();
            this.foreignKey.fromXml(fKNode);
        }
        if ((enumValueNode = node.getChild("Enums")) != null) {
            EnumValue eValue = new EnumValue(new HashMap<String, String>());
            eValue.fromXml(enumValueNode);
            this.enumValue = eValue.getEnumValue();
        }
        if (null != node.getAttributeValue("propertyRelated")) {
            this.relatedBaseProperty = node.getAttributeValue("propertyRelated");
        }
    }

    public boolean isSupportOrm() {
        Object value = this.extensionProps.get("isOrmSupported");
        return value == null ? true : (Boolean)value;
    }

    public Property createCopy() {
        Property p = new Property();
        p.setGroup(this.group);
        p.setAlias(this.alias);
        p.setAppointedDataType(this.appointedDataType);
        p.setAssociateName(this.associateName);
        p.setDataType(this.dataType);
        if (null != this.getDependences()) {
            HashSet<String> dependenseCopy = new HashSet<String>();
            dependenseCopy.addAll(this.getDependences());
            p.setDependences(dependenseCopy);
        }
        p.setForeignKey(this.getForeignKey());
        p.setFormatString(this.getFormatString());
        p.setFormula(this.getFormula());
        p.setHide(this.isHide());
        p.setName(this.getName());
        p.extensionProps.putAll(this.extensionProps);
        p.setNotExisted(this.isNotExisted);
        p.setHideInDataModeling(this.hideInDataModeling);
        if (null != this.getEnumValue()) {
            HashMap<String, String> enumCopy = new HashMap<String, String>();
            enumCopy.putAll(this.getEnumValue());
            p.setEnumValue(enumCopy);
        }
        return p;
    }

    public void setIsVoidEnumProp(boolean enumProp) {
        this.isVoidEnumProp = enumProp;
    }

    public boolean isVoidEnumProp() {
        return this.isVoidEnumProp;
    }
}

