/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Element;

public class Relation {
    public static final int KFW_FROM_POINT = 1;
    public static final int KFW_TO_POINT = 2;
    private String fromEntity;
    private String toEntity;
    private String fromProperty;
    private String toProperty;
    private Related related;
    private int keepFifthWheel = 0;

    public String getFromEntity() {
        return this.fromEntity;
    }

    public void setFromEntity(String name) {
        this.fromEntity = name;
    }

    public String getToEntity() {
        return this.toEntity;
    }

    public void setToEntity(String name) {
        this.toEntity = name;
    }

    public String getFromProperty() {
        return this.fromProperty;
    }

    public void setFromProperty(String name) {
        this.fromProperty = name;
    }

    public String getToProperty() {
        return this.toProperty;
    }

    public void setToProperty(String name) {
        this.toProperty = name;
    }

    public Related getRelated() {
        return this.related;
    }

    public void setRelated(Related related) {
        this.related = related;
    }

    public boolean isFromPointKeepFifthWheel() {
        return (this.keepFifthWheel & 1) == 1;
    }

    public void setFromPointKeepFifthWheel(boolean isKeep) {
        this.keepFifthWheel = isKeep ? (this.keepFifthWheel |= 1) : (this.keepFifthWheel &= 0xFFFFFFFE);
    }

    public boolean isToPointKeepFifthWheel() {
        return (this.keepFifthWheel & 2) == 2;
    }

    public void setToPointKeepFifthWheel(boolean isKeep) {
        this.keepFifthWheel = isKeep ? (this.keepFifthWheel |= 2) : (this.keepFifthWheel &= 0xFFFFFFFD);
    }

    public Element toXml() {
        Element node = new Element("Relation");
        node.setAttribute("fromEntity", this.fromEntity);
        node.setAttribute("fromProperty", this.fromProperty);
        node.setAttribute("toEntity", this.toEntity);
        node.setAttribute("toProperty", this.toProperty);
        node.setAttribute("related", this.related.toPersistance());
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"keepFifthWheel", (Integer)this.keepFifthWheel);
        return node;
    }

    public void fromXml(Element node) throws ModelParseException {
        this.fromEntity = node.getAttributeValue("fromEntity");
        this.fromProperty = node.getAttributeValue("fromProperty");
        this.toEntity = node.getAttributeValue("toEntity");
        this.toProperty = node.getAttributeValue("toProperty");
        if (this.fromEntity == null || this.fromProperty == null || this.toEntity == null || this.toProperty == null) {
            throw new ModelParseException("Incomplete Relation.");
        }
        this.related = Related.fromPersistance(node.getAttributeValue("related"));
        String kfw = node.getAttributeValue("keepFifthWheel");
        if (kfw != null) {
            this.keepFifthWheel = Integer.parseInt(kfw);
        }
    }

    public static enum Related {
        From1To1,
        From1ToN,
        FromNTo1;


        public String toPersistance() {
            if (this == From1To1) {
                return "1-1";
            }
            if (this == From1ToN) {
                return "1-n";
            }
            if (this == FromNTo1) {
                return "n-1";
            }
            throw new RuntimeException("Modify here.");
        }

        public static Related fromPersistance(String name) throws ModelParseException {
            if ("1-1".equals(name)) {
                return From1To1;
            }
            if ("1-n".equals(name)) {
                return From1ToN;
            }
            if ("n-1".equals(name)) {
                return FromNTo1;
            }
            throw new ModelParseException("Unknown Related: " + name);
        }
    }
}

