/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import java.util.concurrent.TimeUnit;

public class ProgressProcessor {
    private long totalRows = -1L;
    private long writeRows = 0L;
    private long dealRows = 0L;
    private long dataLimit = -1L;
    private long lastDataChangedTimeStamp = 0L;
    private IDataLimitlisenter dataLimitlisenter;
    private IDealtRowsChangedLisenter dealtRowsChangedLisenter;
    private static long FIRE_DATA_CHANGED_FREQUENCY = TimeUnit.MILLISECONDS.toMillis(500L);

    public ProgressProcessor(long dataLimit) {
        this.dataLimit = dataLimit;
    }

    public void setDataLimitlisenter(IDataLimitlisenter dataLimitlisenter) {
        this.dataLimitlisenter = dataLimitlisenter;
    }

    public void setDealtRowsChangedLisenter(IDealtRowsChangedLisenter dealtRowsChangedLisenter) {
        this.dealtRowsChangedLisenter = dealtRowsChangedLisenter;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public long getDealRows() {
        return this.dealRows;
    }

    public void dealOneRow() {
        long currnetTimestamp;
        ++this.dealRows;
        if (this.dealtRowsChangedLisenter != null && (currnetTimestamp = System.currentTimeMillis()) - this.lastDataChangedTimeStamp > FIRE_DATA_CHANGED_FREQUENCY) {
            this.lastDataChangedTimeStamp = currnetTimestamp;
            this.dealtRowsChangedLisenter.fireDataChanged(this.dealRows, this.totalRows);
        }
    }

    public void dealtAllRows() {
        if (this.dealtRowsChangedLisenter != null) {
            this.dealtRowsChangedLisenter.fireDataChanged(this.dealRows, this.totalRows);
        }
    }

    public long getWriteRows() {
        return this.writeRows;
    }

    public void writeOneRow() {
        ++this.writeRows;
    }

    public boolean isDataLimit() {
        if (this.dataLimit < 0L || this.writeRows < this.dataLimit) {
            return false;
        }
        if (this.dataLimitlisenter != null) {
            this.dataLimitlisenter.fireDataLimit();
        }
        return true;
    }

    public static interface IDealtRowsChangedLisenter {
        public void fireDataChanged(long var1, long var3);
    }

    public static interface IDataLimitlisenter {
        public void fireDataLimit();
    }
}

