/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition;

import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.SqlConditionBuilder;

public class InSqlConditionBuilder
extends SqlConditionBuilder {
    private int paramNum;
    public static final int MAX_IN_PARAM_NUM = 256;

    public InSqlConditionBuilder(int paramNum) {
        this.paramNum = paramNum;
    }

    @Override
    public String build(String fieldName) {
        int inCount = this.paramNum % 256 == 0 ? this.paramNum / 256 : this.paramNum / 256 + 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inCount; ++i) {
            int paramSize = this.getParamSize(inCount, i);
            String inCondition = this.buildInConditionString(fieldName, paramSize);
            if (i == inCount - 1) {
                sb.append(inCondition);
                continue;
            }
            sb.append(inCondition).append(' ').append("OR").append(' ');
        }
        if (inCount != 1) {
            sb.insert(0, " ( ");
            sb.append(" ) ");
        }
        return sb.toString();
    }

    private int getParamSize(int inCount, int i) {
        if (i == inCount - 1) {
            return this.paramNum - (inCount - 1) * 256;
        }
        return 256;
    }

    private String buildInConditionString(String fieldName, int paramSize) {
        StringBuilder sb = new StringBuilder();
        sb.append(fieldName).append(" in (");
        for (int i = 0; i < paramSize; ++i) {
            if (i < paramSize - 1) {
                sb.append(" ? ").append(',');
                continue;
            }
            sb.append(" ? ");
        }
        sb.append(" ) ");
        return sb.toString();
    }
}

