/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.valueconvert;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.CustomSystemVarValue;
import com.kingdee.bos.qing.data.model.runtime.CompareFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.Set;

public class CustomSystemVarValueHandler
extends ValueHandlerAdapter {
    private PrimaryDataValueHandlerDelegate primaryDataValueHandlerDelegate;
    private CompareFilter compareFilter;
    private QingContext qingContext;

    public CustomSystemVarValueHandler(CompareFilter compareFilter) {
        this.compareFilter = compareFilter;
        this.qingContext = compareFilter.getQingContext();
        this.primaryDataValueHandlerDelegate = compareFilter.getPrimaryDataValueHandler();
    }

    public Object toRuntimeValue(Object originalValue) {
        RuntimeEntity runtimeEntity = this.compareFilter.getRuntimeEntity();
        RuntimeProperty runtimeProperty = this.compareFilter.getRuntimeProperty();
        AbstractSource source = runtimeEntity.getSource();
        AbstractDataSourceDomain sourceDomain = null;
        try {
            sourceDomain = SourceDomainFactory.getSourceDomain(source);
        }
        catch (UnSupportDataSourceException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        CustomSystemVarValue customSystemVarValue = (CustomSystemVarValue)JsonUtil.decodeFromString((String)originalValue.toString(), CustomSystemVarValue.class);
        HashSet<Object> newSets = new HashSet<Object>();
        try {
            Set<String> collection = sourceDomain.getCustomSystemVarValue(this.qingContext, source, runtimeEntity, runtimeProperty, customSystemVarValue);
            if (collection != null && !collection.isEmpty()) {
                for (String value : collection) {
                    try {
                        newSets.add(this.primaryDataValueHandlerDelegate.toRuntimeValue((Object)value));
                    }
                    catch (Exception e) {
                        LogUtil.info((String)("to runtime value error,type not match,originalValue:" + String.valueOf(value)));
                    }
                }
            }
        }
        catch (AbstractSourceException e) {
            LogUtil.info((String)("to runtime value error,type not match,originalValue:" + String.valueOf(originalValue)));
        }
        return newSets;
    }
}

