/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import com.kingdee.bos.qing.data.model.designtime.DMGroupItemView;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntitySubView;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.mdd.IHierarchy;
import com.kingdee.bos.qing.data.model.runtime.mdd.Level;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Hierarchy
implements IHierarchy {
    private final String name;
    private final String displayName;
    private List<Level> levels = new ArrayList<Level>();

    public Hierarchy(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public List<Level> getLevels() {
        return Collections.unmodifiableList(this.levels);
    }

    public void addLevel(Level level) {
        this.levels.add(level);
    }

    public void addAllLevel(List<Level> levels) {
        this.levels.addAll(levels);
    }

    @Override
    public void toDM(Entity entity, EntitySubView entitySubView) {
        List<Property> properties = entity.getProperties();
        if (!this.levels.isEmpty()) {
            Parild parild = null;
            String pcdName = NameUtil.getPureName((String)this.name, new HashMap());
            if (this.levels.size() > 1) {
                Property pcdIdProperty = Hierarchy.createPCDProperty(this.name + "_PCDID", this.displayName + "_PCDID");
                pcdIdProperty.setGroup(pcdName);
                properties.add(pcdIdProperty);
                Property pcdPIdProperty = Hierarchy.createPCDProperty(this.name + "_PCDPID", this.displayName + "_PCDPID");
                pcdPIdProperty.setGroup(pcdName);
                properties.add(pcdPIdProperty);
                Property pcdNameProperty = Hierarchy.createPCDProperty(this.name + "_PCDNAME", this.displayName + "_PCDNAME");
                pcdNameProperty.setGroup(pcdName);
                properties.add(pcdNameProperty);
                parild = new Parild();
                parild.setNecessary(Parild.Necessary.RootRepresented);
                parild.setName(pcdName);
                parild.setAssociateName(this.name);
                parild.setAlias(this.displayName);
                parild.setIdField(pcdIdProperty.getName());
                parild.setParentIdField(pcdPIdProperty.getName());
                parild.setDefaultDisplayField(pcdNameProperty.getName());
                if (entity.getParilds() == null) {
                    entity.setParilds(new ArrayList<Parild>());
                }
                entity.getParilds().add(parild);
                if (entitySubView != null) {
                    entitySubView.getViewItems().add(new DMGroupItemView(pcdIdProperty.getName()));
                    entitySubView.getViewItems().add(new DMGroupItemView(pcdPIdProperty.getName()));
                    entitySubView.getViewItems().add(new DMGroupItemView(pcdNameProperty.getName()));
                } else {
                    if (entity.getViewItems() == null) {
                        entity.setViewItems(new ArrayList<AbstractDMViewItem>());
                    }
                    entity.getViewItems().add(new DMGroupItemView(pcdIdProperty.getName()));
                    entity.getViewItems().add(new DMGroupItemView(pcdPIdProperty.getName()));
                    entity.getViewItems().add(new DMGroupItemView(pcdNameProperty.getName()));
                }
            }
            for (Level level : this.levels) {
                Property property = level.toDM();
                properties.add(property);
                if (parild != null) {
                    property.setGroup(pcdName);
                }
                if (entitySubView != null) {
                    entitySubView.getViewItems().add(new DMGroupItemView(property.getName()));
                    continue;
                }
                entity.getViewItems().add(new DMGroupItemView(property.getName()));
            }
        }
    }

    private static Property createPCDProperty(String name, String displayName) {
        Property property = new Property();
        property.setName(NameUtil.getPureName((String)name, new HashMap()));
        property.setAssociateName(name);
        property.setAlias(displayName);
        property.setDataType(DesigningDataType.STRING);
        property.setAppointedDataType(DesigningDataType.STRING);
        return property;
    }
}

