/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.HashMap;

public class Level {
    private final String name;
    private final String displayName;
    private final int depth;
    private final boolean calculated;
    private final int cardinality;
    private final Type type;

    public Level(String name, String displayName, int depth, Type type, boolean calculated, int cardinality) {
        this.name = name;
        this.displayName = displayName;
        this.depth = depth;
        this.type = type;
        this.calculated = calculated;
        this.cardinality = cardinality;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public Type getLevelType() {
        return this.type;
    }

    public Property toDM() {
        Property property = new Property();
        property.setName(NameUtil.getPureName((String)this.getName(), new HashMap()));
        property.setAssociateName(this.getName());
        property.setAlias(this.getDisplayName());
        property.setDataType(DesigningDataType.STRING);
        property.setAppointedDataType(DesigningDataType.STRING);
        return property;
    }

    public static enum Type {
        REGULAR(0),
        ALL(1),
        NULL(-1),
        TIME_YEARS(20),
        TIME_HALF_YEAR(36),
        TIME_QUARTERS(68),
        TIME_MONTHS(132),
        TIME_WEEKS(260),
        TIME_DAYS(516),
        TIME_HOURS(772),
        TIME_MINUTES(1028),
        TIME_SECONDS(2052),
        TIME_UNDEFINED(4100),
        GEO_CONTINENT(8193),
        GEO_REGION(8194),
        GEO_COUNTRY(8195),
        GEO_STATE_OR_PROVINCE(8196),
        GEO_COUNTY(8197),
        GEO_CITY(8198),
        GEO_POSTALCODE(8199),
        GEO_POINT(8200),
        ORG_UNIT(4113),
        BOM_RESOURCE(4114),
        QUANTITATIVE(4115),
        ACCOUNT(4116),
        CUSTOMER(4129),
        CUSTOMER_GROUP(4130),
        CUSTOMER_HOUSEHOLD(4131),
        PRODUCT(4145),
        PRODUCT_GROUP(4146),
        SCENARIO(4117),
        UTILITY(4118),
        PERSON(4161),
        COMPANY(4162),
        CURRENCY_SOURCE(4177),
        CURRENCY_DESTINATION(4178),
        CHANNEL(4193),
        REPRESENTATIVE(4194),
        PROMOTION(4209);

        private final int xmlaOrdinal;

        private Type(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        public String xmlaName() {
            return "MDLEVEL_TYPE_" + this.name();
        }

        public String getDescription() {
            return "";
        }

        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        public boolean isTime() {
            switch (this) {
                case TIME_YEARS: 
                case TIME_HALF_YEAR: 
                case TIME_QUARTERS: 
                case TIME_MONTHS: 
                case TIME_WEEKS: 
                case TIME_DAYS: 
                case TIME_HOURS: 
                case TIME_MINUTES: 
                case TIME_SECONDS: 
                case TIME_UNDEFINED: {
                    return true;
                }
            }
            return false;
        }
    }
}

