/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.exception.entity.EntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaHelper;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.EntityFixContext;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityPkFilterProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixUnionChildEntityFilter;
import com.kingdee.bos.qing.data.model.runtime.process.FixedEntityGroup;
import com.kingdee.bos.qing.data.model.runtime.process.ITreePropertyProcessor;
import com.kingdee.bos.qing.data.model.runtime.process.SubUnionEntityContext;
import com.kingdee.bos.qing.data.model.runtime.process.UnionEntityFixContext;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.util.CustomPropertyWhitePaper;
import com.kingdee.bos.qing.data.util.EntityErrorHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixBizUnionEntityProcess {
    private UnionEntityFixContext fixContext;
    private QingContext qingContext;

    public FixBizUnionEntityProcess(QingContext qingContext, UnionEntityFixContext fixContext) {
        this.fixContext = fixContext;
        this.qingContext = qingContext;
    }

    public void fixUnionEntity() {
        this.checkEntityExisted();
        this.checkEntityPermission();
        this.syncCurrentEntityFromLiveEntityMeta();
        this.handleNotExistedProperty();
        List<UnionEntity> unionEntityList = this.fixContext.getUnionEntities();
        for (UnionEntity unionEntity : unionEntityList) {
            this.setUnionEntityErrorInfo(unionEntity);
        }
        this.parseUnionCalcProperty();
        this.syncParentUnionFilterAndProps();
        this.syncUnionBasePropAndFilterToInnerEntity();
        this.handleFlexFieldIfExist();
        this.addEntityPkPropNotNullFilter();
    }

    private void addEntityPkPropNotNullFilter() {
        FixEntityPkFilterProcess pkFilterProcess = new FixEntityPkFilterProcess(this.fixContext.getFixScene());
        List<UnionEntity> unionEntities = this.fixContext.getUnionEntities();
        for (UnionEntity unionEntity : unionEntities) {
            List<Entity> children = unionEntity.getChildren();
            for (Entity entity : children) {
                pkFilterProcess.process(entity, this.fixContext.getDataSourceDomain());
            }
        }
    }

    private void handleFlexFieldIfExist() {
        List<UnionEntity> unionEntities = this.fixContext.getUnionEntities();
        AbstractDataSourceDomain dataSourceDomain = this.fixContext.getDataSourceDomain();
        ITreePropertyProcessor treePropertyProcessor = dataSourceDomain.createTreePropertyProcessor();
        for (UnionEntity unionEntity : unionEntities) {
            this.createFlexTreePropInUnionEntity(unionEntity);
            this.makeFlexFieldAlignFromUnionToSubEntity(unionEntity);
            if (null == treePropertyProcessor) continue;
            for (Entity subEntity : unionEntity.getChildren()) {
                treePropertyProcessor.fixTreeProperty(this.fixContext.getFixScene(), subEntity);
            }
            treePropertyProcessor.fixTreeProperty(this.fixContext.getFixScene(), unionEntity);
        }
    }

    private void setUnionEntityErrorInfo(UnionEntity unionEntity) {
        for (Entity entity : unionEntity.getChildren()) {
            EntityErrorInfo entityErrorInfo = entity.getErrorInfo();
            if (entityErrorInfo == null) continue;
            unionEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.UNIONENTITY_CHILDTABLE_HAVE_PROBLEM));
        }
    }

    private void makeFlexFieldAlignFromUnionToSubEntity(UnionEntity unionEntity) {
        List<TreeProperty> orderedTreeProperty = unionEntity.getTreeNodeProperties();
        for (TreeProperty treeProperty : orderedTreeProperty) {
            if (treeProperty.getTreeType() != 0) continue;
            List<TreeProperty> relatedTreeProperties = this.getOrCreateSubEntityRelatedTreeProp(unionEntity, treeProperty.getName());
            for (TreeProperty treePropInSubEntity : relatedTreeProperties) {
                treePropInSubEntity.getChildren().clear();
            }
            List<Property> baseFlexFieldChildren = treeProperty.getChildren();
            for (Property property : baseFlexFieldChildren) {
                String key = property.getExtensionValue("subFlexFieldKey", String.class);
                for (TreeProperty treePropInSubEntity : relatedTreeProperties) {
                    Property p = treePropInSubEntity.getSubFlexField(key);
                    if (null != p) {
                        p.setName(property.getName());
                        p.addExtensionData("reservedName", p.getName());
                        p.setAppointedDataType(property.getOutputDataType());
                        p.setRelatedBaseProperty(property.getName());
                        treePropInSubEntity.getChildren().add(p);
                        continue;
                    }
                    Property notExistedProp = property.createCopy();
                    notExistedProp.addExtensionData("isOrmSupported", false);
                    notExistedProp.setInvalid4Union(true);
                    notExistedProp.setParent(treePropInSubEntity.getInnerProp());
                    treePropInSubEntity.getChildren().add(notExistedProp);
                }
            }
        }
    }

    private List<TreeProperty> getOrCreateSubEntityRelatedTreeProp(UnionEntity unionEntity, String baseTreePropName) {
        List<Entity> children = unionEntity.getChildren();
        ArrayList<TreeProperty> treeProperties = new ArrayList<TreeProperty>();
        for (Entity entity : children) {
            SubUnionEntityContext subUnionEntityContext;
            EntityFixContext subEntityFixContext;
            Property dummyFlexFieldProp;
            List<TreeProperty> subEntityTreeProps = entity.getTreeNodeProperties();
            TreeProperty matchedTreeProp = null;
            for (TreeProperty treeProperty : subEntityTreeProps) {
                Property innerProp = treeProperty.getInnerProp();
                String relatedBaseProp = innerProp.getRelatedBaseProperty();
                if (!relatedBaseProp.equals(baseTreePropName)) continue;
                matchedTreeProp = treeProperty;
                break;
            }
            if (null == matchedTreeProp && null != (dummyFlexFieldProp = (subEntityFixContext = (subUnionEntityContext = this.fixContext.getSubContext(unionEntity.getName())).getEntityFixContext(entity.getName())).findMappingProperty(baseTreePropName))) {
                TreeProperty dummyTreeProp = new TreeProperty(dummyFlexFieldProp, new ArrayList<Property>(), 0);
                subEntityTreeProps.add(dummyTreeProp);
                matchedTreeProp = dummyTreeProp;
            }
            if (null == matchedTreeProp) continue;
            treeProperties.add(matchedTreeProp);
        }
        return treeProperties;
    }

    private void createFlexTreePropInUnionEntity(UnionEntity unionEntity) {
        List<Entity> children = unionEntity.getChildren();
        List<TreeProperty> orderedTreeProperty = unionEntity.getTreeNodeProperties();
        HashMap<String, TreeProperty> unionEntityTreePropMap = new HashMap<String, TreeProperty>();
        for (Entity entity : children) {
            List<TreeProperty> treeProperties = entity.getTreeNodeProperties();
            if (treeProperties.isEmpty()) continue;
            for (TreeProperty treeProperty : treeProperties) {
                if (treeProperty.getTreeType() != 0) continue;
                Property innerProp = treeProperty.getInnerProp();
                String baseRelatedPropName = innerProp.getRelatedBaseProperty();
                TreeProperty baseUnionTreeProp = (TreeProperty)unionEntityTreePropMap.get(baseRelatedPropName);
                if (null == baseUnionTreeProp) {
                    SubUnionEntityContext unionEntityContext = this.fixContext.getSubContext(unionEntity.getName());
                    Property baseProperty = unionEntityContext.getLocalPropMap().get(baseRelatedPropName);
                    baseProperty.addExtensionData("isFlexField", true);
                    if (null == baseProperty) continue;
                    TreeProperty unionEntityTreeProp = new TreeProperty(baseProperty, treeProperty.createCopyChildren(), treeProperty.getTreeType());
                    orderedTreeProperty.add(unionEntityTreeProp);
                    unionEntityTreePropMap.put(baseRelatedPropName, unionEntityTreeProp);
                    continue;
                }
                baseUnionTreeProp.mergeSubProperty(treeProperty.getChildren());
            }
        }
    }

    private void handleNotExistedProperty() {
        BoxFixScene boxFixScene = this.fixContext.getFixScene();
        switch (boxFixScene) {
            case extract: {
                this.removeNotExistedUnionEntityPropertyOnExtract();
                break;
            }
            case datamodeling: 
            case preview: {
                this.findAndSetNotExistedBasePropStatus();
            }
        }
    }

    private void findAndSetNotExistedBasePropStatus() {
        List<UnionEntity> unionEntities = this.fixContext.getUnionEntities();
        for (UnionEntity unionEntity : unionEntities) {
            List<Entity> children = unionEntity.getChildren();
            HashSet<String> allUnionEntityChildPropertyNameSet = new HashSet<String>();
            SubUnionEntityContext subUnionEntityContext = this.fixContext.getSubContext(unionEntity.getName());
            for (Entity entity : children) {
                EntityFixContext entityFixContext = subUnionEntityContext.getEntityFixContext(entity.getName());
                allUnionEntityChildPropertyNameSet.addAll(entityFixContext.getRelatedBasePropExcludeUnExisted());
            }
            List<Property> baseUnionProps = unionEntity.getProperties();
            for (Property property : baseUnionProps) {
                if (property.isCalculation() || CustomPropertyWhitePaper.isInWhitePaper(property.getName()) || allUnionEntityChildPropertyNameSet.contains(property.getName())) continue;
                property.setNotExisted(true);
            }
        }
    }

    private void syncUnionBasePropAndFilterToInnerEntity() {
        if (this.fixContext.getFixScene() == BoxFixScene.datamodeling) {
            return;
        }
        FixUnionChildEntityFilter filterProcessor = new FixUnionChildEntityFilter();
        for (UnionEntity unionEntity : this.fixContext.getUnionEntities()) {
            List<Property> unionEntityProperties = unionEntity.getProperties();
            List<Entity> childrenEntity = unionEntity.getChildren();
            for (Entity childEntity : childrenEntity) {
                ArrayList<Property> newUnionEntityChildProperties = new ArrayList<Property>();
                HashMap<String, Property> propertyMap = new HashMap<String, Property>();
                HashMap<String, Property> baseRelatedPropertyMap = new HashMap<String, Property>();
                EntityFixContext entityFixContext = this.fixContext.getBizEntityFixContext(childEntity.getName());
                for (Property unionEntityProperty : unionEntityProperties) {
                    if (unionEntityProperty.isCalculation()) {
                        Property newProperty = unionEntityProperty.createCopy();
                        entityFixContext.addProperty(newProperty);
                        newUnionEntityChildProperties.add(newProperty);
                        propertyMap.put(newProperty.getName(), newProperty);
                        continue;
                    }
                    String unionBasePropertyName = unionEntityProperty.getName();
                    Property childEntityMapProperty = entityFixContext.findMappingProperty(unionBasePropertyName);
                    if (childEntityMapProperty != null) {
                        childEntityMapProperty.addExtensionData("reservedName", childEntityMapProperty.getName());
                        childEntityMapProperty.setName(unionBasePropertyName);
                        childEntityMapProperty.setAppointedDataType(unionEntityProperty.getOutputDataType());
                        newUnionEntityChildProperties.add(childEntityMapProperty);
                        propertyMap.put(unionBasePropertyName, childEntityMapProperty);
                        baseRelatedPropertyMap.put(unionBasePropertyName, childEntityMapProperty);
                        if (!childEntityMapProperty.isPkProperty()) continue;
                        unionEntityProperty.addExtensionData("unionPropUnRemovable", "true");
                        continue;
                    }
                    Property newProperty = unionEntityProperty.createCopy();
                    String newPropertyName = newProperty.getName();
                    newProperty.setInvalid4Union(true);
                    newProperty.setRelatedBaseProperty(newPropertyName);
                    newUnionEntityChildProperties.add(newProperty);
                    propertyMap.put(newPropertyName, newProperty);
                    baseRelatedPropertyMap.put(unionBasePropertyName, newProperty);
                }
                childEntity.setProperties(newUnionEntityChildProperties);
                entityFixContext.updateLocalPropMap(propertyMap);
                entityFixContext.updateRelatedPropMap(baseRelatedPropertyMap);
                filterProcessor.processFilterItem(unionEntity, childEntity, propertyMap);
            }
        }
    }

    private void parseUnionCalcProperty() {
        List<UnionEntity> unionEntities = this.fixContext.getUnionEntities();
        for (UnionEntity unionEntity : unionEntities) {
            SubUnionEntityContext context = this.fixContext.getSubContext(unionEntity.getName());
            if (context.isAllCalPropFixed()) continue;
            FormulaHelper.handleAll(unionEntity.getProperties(), context.getLocalPropMap());
        }
    }

    private void syncParentUnionFilterAndProps() {
        if (this.fixContext.getFixScene() == BoxFixScene.datamodeling) {
            return;
        }
        List<UnionEntity> unionEntities = this.fixContext.getUnionEntities();
        for (UnionEntity unionEntity : unionEntities) {
            String parentUnionName = unionEntity.getParentName();
            if (StringUtils.isEmpty((CharSequence)parentUnionName)) continue;
            List<Property> dependencyPropCopySet = this.collectAndCopyFilterDependencyProps(parentUnionName);
            List<FilterItem> filterItemsCopyFromParent = this.makeFilterCopy(parentUnionName);
            this.pushDownParentFilterItemProperty(parentUnionName, dependencyPropCopySet, unionEntity);
            if (null == filterItemsCopyFromParent || filterItemsCopyFromParent.size() <= 0) continue;
            List<FilterItem> oldFilterItems = unionEntity.getFilters();
            oldFilterItems = FilterItem.appendFilterItem(oldFilterItems, filterItemsCopyFromParent, FilterItem.LogicOp.AND);
            unionEntity.setFilters(oldFilterItems);
        }
    }

    private void renameIfRepeat(Property property, Map<String, Property> propertyMap) {
        String rawPropName;
        int index = 1;
        String propName = rawPropName = property.getName();
        while (propertyMap.containsKey(propName)) {
            propName = rawPropName + "_" + index;
            ++index;
        }
        property.setName(propName);
    }

    private void pushDownParentFilterItemProperty(String parentUnionName, List<Property> dependencyPropSet, UnionEntity childUnionEntity) {
        if (null == dependencyPropSet || dependencyPropSet.isEmpty()) {
            return;
        }
        SubUnionEntityContext parentUnionContext = this.fixContext.getSubContext(parentUnionName);
        SubUnionEntityContext childUnionContext = this.fixContext.getSubContext(childUnionEntity.getName());
        for (Property parentBasePropCopy : dependencyPropSet) {
            if (CustomPropertyWhitePaper.isInWhitePaper(parentBasePropCopy.getName())) continue;
            Map<String, Property> mappingProperties = parentUnionContext.findMappingProperty(parentBasePropCopy.getName());
            this.renameIfRepeat(parentBasePropCopy, childUnionContext.getLocalPropMap());
            childUnionEntity.getProperties().add(parentBasePropCopy);
            childUnionContext.addNewProp(parentBasePropCopy);
            for (Map.Entry<String, Property> entry : mappingProperties.entrySet()) {
                String parentEntityName = entry.getKey();
                Property parentEntityMapProp = entry.getValue();
                Entity childEntity = childUnionContext.findEntityByParentName(parentEntityName);
                if (null == childEntity) continue;
                EntityFixContext entityFixContext = childUnionContext.getEntityFixContext(childEntity.getName());
                Property copyProp = parentEntityMapProp.createCopy();
                copyProp.setRelatedBaseProperty(parentBasePropCopy.getName());
                this.renameIfRepeat(copyProp, entityFixContext.getLocalPropMap());
                childEntity.getProperties().add(copyProp);
                entityFixContext.addProperty(copyProp);
            }
        }
    }

    private List<FilterItem> makeFilterCopy(String unionEntityName) {
        UnionEntity parentUnion = this.fixContext.getUnionEntity(unionEntityName);
        List<FilterItem> parentEntityFilters = parentUnion.getFilters();
        if (null == parentEntityFilters || parentEntityFilters.isEmpty()) {
            return null;
        }
        ArrayList<FilterItem> newFilterItems = new ArrayList<FilterItem>(parentEntityFilters.size());
        for (FilterItem parentEntityFilter : parentEntityFilters) {
            FilterItem newFilterItem = parentEntityFilter.createCopy();
            newFilterItem.setPrediction(parentEntityFilter.getPrediction());
            newFilterItems.add(newFilterItem);
        }
        return newFilterItems;
    }

    private List<Property> collectAndCopyFilterDependencyProps(String unionEntityName) {
        Property parentEntityProperty;
        UnionEntity parentUnion = this.fixContext.getUnionEntity(unionEntityName);
        List<FilterItem> parentEntityFilters = parentUnion.getFilters();
        if (null == parentEntityFilters || parentEntityFilters.isEmpty()) {
            return null;
        }
        SubUnionEntityContext parentUnionEntityContext = this.fixContext.getSubContext(unionEntityName);
        HashSet<String> filterItemDependencePropertyNameSet = new HashSet<String>(parentEntityFilters.size());
        Map<String, Property> parentEntityPropertyMap = parentUnionEntityContext.getLocalPropMap();
        for (FilterItem parentEntityFilter : parentEntityFilters) {
            Set<String> parentEntityPropertyDependences;
            String newFilterItemPropertyName = parentEntityFilter.getProprety();
            parentEntityProperty = parentEntityPropertyMap.get(newFilterItemPropertyName);
            if (parentEntityProperty == null) continue;
            if (parentEntityProperty.isCalculation() && (parentEntityPropertyDependences = parentEntityProperty.getDependences()) != null && !parentEntityPropertyDependences.isEmpty()) {
                filterItemDependencePropertyNameSet.addAll(parentEntityPropertyDependences);
            }
            filterItemDependencePropertyNameSet.add(newFilterItemPropertyName);
        }
        ArrayList<Property> propertyCopies = new ArrayList<Property>(10);
        for (String parentPropName : filterItemDependencePropertyNameSet) {
            parentEntityProperty = parentEntityPropertyMap.get(parentPropName);
            Property newProperty = parentEntityProperty.createCopy();
            newProperty.setInvalidForParent(true);
            propertyCopies.add(newProperty);
        }
        return propertyCopies;
    }

    private void removeNotExistedUnionEntityPropertyOnExtract() {
        List<UnionEntity> unionEntities = this.fixContext.getUnionEntities();
        for (UnionEntity unionEntity : unionEntities) {
            List<Entity> children = unionEntity.getChildren();
            HashSet<String> allUnionEntityChildPropertyNameSet = new HashSet<String>();
            SubUnionEntityContext subUnionEntityContext = this.fixContext.getSubContext(unionEntity.getName());
            for (Entity entity : children) {
                EntityFixContext entityFixContext = subUnionEntityContext.getEntityFixContext(entity.getName());
                allUnionEntityChildPropertyNameSet.addAll(entityFixContext.getRelatedBasePropNames());
            }
            this.removeIllegalUnionProperty(unionEntity, allUnionEntityChildPropertyNameSet, subUnionEntityContext);
        }
    }

    private void removeIllegalUnionProperty(UnionEntity unionEntity, Set<String> allUnionEntityChildPropertyNameSet, SubUnionEntityContext subUnionEntityContext) {
        ArrayList<Property> propsRemoved = new ArrayList<Property>();
        List<Property> unionEntityProperties = unionEntity.getProperties();
        Iterator<Property> propIt = unionEntityProperties.iterator();
        ArrayList<Property> calcProperties = new ArrayList<Property>();
        while (propIt.hasNext()) {
            Property property = propIt.next();
            if (property.isCalculation()) {
                calcProperties.add(property);
                continue;
            }
            if (allUnionEntityChildPropertyNameSet.contains(property.getName())) continue;
            propIt.remove();
            propsRemoved.add(property);
        }
        subUnionEntityContext.removeProps(propsRemoved);
        propsRemoved.clear();
        if (!calcProperties.isEmpty()) {
            FormulaHelper.handleAll(unionEntityProperties, subUnionEntityContext.getLocalPropMap());
            subUnionEntityContext.setAllCalPropFixed(true);
            Iterator<Property> iterator = unionEntityProperties.iterator();
            while (iterator.hasNext()) {
                Property property = iterator.next();
                if (!property.isCalculation() || !property.isFormulaInvalid()) continue;
                iterator.remove();
                propsRemoved.add(property);
            }
        }
        subUnionEntityContext.removeProps(propsRemoved);
    }

    private void checkEntityPermission() {
        List<FixedEntityGroup> entityGroups = this.fixContext.getFixedEntityGroups();
        AbstractDataSourceDomain sourceDomain = this.fixContext.getDataSourceDomain();
        for (FixedEntityGroup entityGroup : entityGroups) {
            List<Entity> innerEntities = entityGroup.getEntities();
            for (Entity entity : innerEntities) {
                EntityErrorInfo errorInfo;
                try {
                    sourceDomain.checkEntityPermission(this.qingContext, entity);
                    sourceDomain.checkSupportQingAnalysis(this.qingContext, entity);
                }
                catch (NoEntityPermissionException e) {
                    errorInfo = new EntityErrorInfo(EntityErrorState.NOTEXISTUSERAUTHORITY);
                    errorInfo.setErrorDesc(e.getMessage());
                    entity.setErrorInfo(errorInfo);
                }
                catch (EntityNotSupportQingAnalysisException e) {
                    errorInfo = new EntityErrorInfo(EntityErrorState.BIZMETANOTSUPPORT);
                    errorInfo.setErrorDesc(e.getMessage());
                    entity.setErrorInfo(errorInfo);
                }
            }
        }
    }

    private void checkEntityExisted() {
        List<FixedEntityGroup> entityGroups = this.fixContext.getFixedEntityGroups();
        for (FixedEntityGroup entityGroup : entityGroups) {
            EntityErrorInfo errorInfo;
            List<Entity> innerEntities = entityGroup.getEntities();
            DesigntimeDataObject designtimeDataObject = entityGroup.getDesigntimeDataObject();
            if (null == designtimeDataObject) {
                String msg = EntityErrorState.TABLENOTEXIST.getI18n(this.qingContext);
                List<Entity> entities = entityGroup.getEntities();
                for (Entity entity : entities) {
                    errorInfo = new EntityErrorInfo(EntityErrorState.TABLENOTEXIST);
                    String errorMsg = msg.replace("#1", entity.getAlias());
                    errorInfo.setErrorDesc(errorMsg);
                    entity.setErrorInfo(errorInfo);
                }
                continue;
            }
            for (Entity entity : innerEntities) {
                Entity parentEntity;
                EntityErrorState errorState;
                String parentEntityName = entity.getParentName();
                if (null != parentEntityName && (errorState = EntityErrorHelper.getErrorState(parentEntity = entityGroup.getEntityByName(parentEntityName))) == EntityErrorState.TABLENOTEXIST) {
                    EntityErrorInfo errorInfo2 = new EntityErrorInfo(errorState);
                    String msg = errorState.getI18n(this.qingContext);
                    String errorMsg = msg.replace("#1", entity.getAlias());
                    errorInfo2.setErrorDesc(errorMsg);
                    entity.setErrorInfo(errorInfo2);
                    continue;
                }
                Entity live = designtimeDataObject.getEntityByAssosiateName(entity.getAssociateName());
                if (null != live) continue;
                errorInfo = new EntityErrorInfo(EntityErrorState.TABLENOTEXIST);
                String msg = EntityErrorState.TABLENOTEXIST.getI18n(this.qingContext);
                String errorMsg = msg.replace("#1", entity.getAlias());
                errorInfo.setErrorDesc(errorMsg);
                entity.setErrorInfo(errorInfo);
            }
        }
    }

    private void doSyncWithLiveEntity(Entity local, Entity live) {
        BoxFixScene fixScene = this.fixContext.getFixScene();
        AbstractDataSourceDomain sourceDomain = this.fixContext.getDataSourceDomain();
        switch (fixScene) {
            case datamodeling: 
            case preview: {
                sourceDomain.fixLocalEntityPropertyFromLive(local, live, false);
                break;
            }
            case extract: {
                List<Property> removed = sourceDomain.fixLocalEntityPropertyFromLive(local, live, true);
                EntityFixContext bizEntityFixContent = this.fixContext.getBizEntityFixContext(local.getName());
                bizEntityFixContent.removeEntityProps(removed);
            }
        }
    }

    private void syncCurrentEntityFromLiveEntityMeta() {
        List<FixedEntityGroup> entityGroups = this.fixContext.getFixedEntityGroups();
        AbstractDataSourceDomain dataSourceDomain = this.fixContext.getDataSourceDomain();
        for (FixedEntityGroup entityGroup : entityGroups) {
            List<Entity> innerEntities = entityGroup.getEntities();
            for (Entity entity : innerEntities) {
                Entity liveEntity = entityGroup.getLiveEntity(entity.getAssociateName());
                this.doSyncWithLiveEntity(entity, liveEntity);
                if (null == liveEntity) continue;
                dataSourceDomain.fixEntityExtension(this.qingContext, entity, entityGroup.getDesigntimeDataObject());
            }
        }
    }
}

