/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaHelper;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.IParentEntityFilterProcessor;
import com.kingdee.bos.qing.data.util.PropertyNameKeySelector;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixEntityFilterItemWithParentRuntimeProcess
implements IParentEntityFilterProcessor {
    private AbstractDataSourceDomain sourceDomain;

    public FixEntityFilterItemWithParentRuntimeProcess(AbstractDataSourceDomain sourceDomain) {
        this.sourceDomain = sourceDomain;
    }

    @Override
    public void fixFilterItemWithParentFilter(BoxFixScene fixScene, Entity dmEntity, Map<String, AbstractEntity> entitysMap) {
        if (fixScene == BoxFixScene.datamodeling) {
            return;
        }
        AbstractEntity parentEntity = entitysMap.get(dmEntity.getParentName());
        if (null == parentEntity) {
            FormulaHelper.handleAll(dmEntity.getProperties());
            return;
        }
        List<FilterItem> parentEntityFilters = parentEntity.getFilters();
        if (parentEntityFilters != null && !parentEntityFilters.isEmpty()) {
            Map parentEntityPropertyMap = MapUtils.collectionToMap(parentEntity.getProperties(), (MapUtils.IMapKeySelector)new PropertyNameKeySelector());
            HashSet<String> filterItemDependencePropertyNameSet = new HashSet<String>(parentEntityFilters.size());
            ArrayList<FilterItem> newFilterItems = new ArrayList<FilterItem>(parentEntityFilters.size());
            for (FilterItem filterItem : parentEntityFilters) {
                String dependencyPropName;
                FilterItem newFilterItem = filterItem.createCopy();
                newFilterItem.setPrediction(filterItem.getPrediction());
                newFilterItems.add(newFilterItem);
                String newFilterItemPropertyName = newFilterItem.getProprety();
                Property parentEntityProperty = (Property)parentEntityPropertyMap.get(newFilterItemPropertyName);
                if (parentEntityProperty.isCalculation()) {
                    Set<String> parentEntityPropertyDependences = parentEntityProperty.getDependences();
                    if (parentEntityPropertyDependences != null && !parentEntityPropertyDependences.isEmpty()) {
                        filterItemDependencePropertyNameSet.addAll(parentEntityPropertyDependences);
                    }
                } else if (!parentEntityProperty.isSupportOrm() && null != (dependencyPropName = parentEntityProperty.getExtensionValue("fromOriginPropName", String.class))) {
                    Property parentDependencyProperty = (Property)parentEntityPropertyMap.get(dependencyPropName);
                    if (null != parentDependencyProperty) {
                        filterItemDependencePropertyNameSet.add(dependencyPropName);
                    } else {
                        this.sourceDomain.appendParentEntityMetaField(parentEntityProperty, dmEntity, (Entity)parentEntity);
                    }
                }
                filterItemDependencePropertyNameSet.add(newFilterItemPropertyName);
            }
            HashMap propertyNameRepeatTime = new HashMap();
            for (Property property : dmEntity.getProperties()) {
                NameUtil.getPureName((String)property.getName(), propertyNameRepeatTime);
            }
            for (String filterItemDependencePropertyName : filterItemDependencePropertyNameSet) {
                Property parentEntityProperty = (Property)parentEntityPropertyMap.get(filterItemDependencePropertyName);
                Property newProperty = parentEntityProperty.createCopy();
                newProperty.setInvalidForParent(true);
                String oldPropertyName = newProperty.getName();
                if (propertyNameRepeatTime.containsKey(oldPropertyName)) continue;
                dmEntity.getProperties().add(newProperty);
            }
            List<FilterItem> list2 = dmEntity.getFilters();
            list2 = FilterItem.appendFilterItem(list2, newFilterItems, FilterItem.LogicOp.AND);
            dmEntity.setFilters(list2);
        }
    }
}

