/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixIllegalSourceProcess {
    public static void process(QingContext qingContext, List<AbstractSource> sources, List<AbstractEntity> abstractEntities) {
        HashMap<String, List<Entity>> entityMap = new HashMap<String, List<Entity>>(sources.size());
        if (!abstractEntities.isEmpty()) {
            for (AbstractEntity abstractEntity : abstractEntities) {
                if (abstractEntity instanceof Entity) {
                    String sourceName = ((Entity)abstractEntity).getSource();
                    FixIllegalSourceProcess.setMapValue(entityMap, (Entity)abstractEntity, sourceName);
                    continue;
                }
                if (!(abstractEntity instanceof UnionEntity)) continue;
                List<Entity> childrenEntityList = ((UnionEntity)abstractEntity).getChildren();
                for (Entity entity : childrenEntityList) {
                    String sourceName = entity.getSource();
                    FixIllegalSourceProcess.setMapValue(entityMap, entity, sourceName);
                }
            }
        }
        HashSet<String> removeSourceNameSet = new HashSet<String>();
        if (sources != null) {
            Iterator<AbstractSource> sourcesIterator = sources.iterator();
            while (sourcesIterator.hasNext()) {
                AbstractSource source = sourcesIterator.next();
                try {
                    AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomain(source);
                    domain.checkSourceLegality(qingContext, source, (List)entityMap.get(source.getName()), domain);
                }
                catch (UnSupportDataSourceException e) {
                    removeSourceNameSet.add(source.getName());
                    sourcesIterator.remove();
                }
            }
        }
        FixIllegalSourceProcess.removeSourceEntity(removeSourceNameSet, abstractEntities);
    }

    private static void setMapValue(Map<String, List<Entity>> entityList, Entity abstractEntity, String sourceName) {
        if (entityList.containsKey(sourceName)) {
            entityList.get(sourceName).add(abstractEntity);
        } else {
            ArrayList<Entity> entityArrayList = new ArrayList<Entity>();
            entityArrayList.add(abstractEntity);
            entityList.put(sourceName, entityArrayList);
        }
    }

    private static void removeSourceEntity(Set<String> remvoeSourceNameSet, List<AbstractEntity> abstractEntities) {
        if (remvoeSourceNameSet == null || remvoeSourceNameSet.isEmpty()) {
            return;
        }
        Iterator<AbstractEntity> abstractEntitiesIterator = abstractEntities.iterator();
        while (abstractEntitiesIterator.hasNext()) {
            AbstractEntity abstractEntity = abstractEntitiesIterator.next();
            if (abstractEntity instanceof Entity) {
                Entity entity = (Entity)abstractEntity;
                String sourceName = entity.getSource();
                if (!remvoeSourceNameSet.contains(sourceName)) continue;
                abstractEntitiesIterator.remove();
                continue;
            }
            if (!(abstractEntity instanceof UnionEntity)) continue;
            UnionEntity unionEntity = (UnionEntity)abstractEntity;
            List<Entity> children = unionEntity.getChildren();
            Iterator<Entity> childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                Entity entity = childrenIterator.next();
                String sourceName = entity.getSource();
                if (!remvoeSourceNameSet.contains(sourceName)) continue;
                childrenIterator.remove();
            }
            if (!children.isEmpty()) continue;
            abstractEntitiesIterator.remove();
        }
    }
}

