/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.process.AbstractFixUnionEntityChildProcessor;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.EntityFixProcessable;
import com.kingdee.bos.qing.data.model.runtime.process.FixAbstractEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityColumnToRowProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixUnionChildEntityProcess4ColToRow;
import com.kingdee.bos.qing.data.model.runtime.process.FixUnionEntityChildRuntimeBaseProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixUnionEntityIllegalPropertyRuntimeProcess;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.util.PropertyRelatedBaseKeySelector;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FixUnionEntityProcess
implements EntityFixProcessable<UnionEntity> {
    private FixEntityProcess entityProcess;
    private FixUnionEntityIllegalPropertyRuntimeProcess fixUnionEntityIllegalPropertyProcess;
    private FixEntityColumnToRowProcess columnToRowProcess;
    private BoxFixScene fixScene;

    public FixUnionEntityProcess(QingContext qingContext, Box box, BoxFixScene boxFixScene) {
        this.fixScene = boxFixScene;
        this.entityProcess = new FixEntityProcess(qingContext, box, boxFixScene);
        this.fixUnionEntityIllegalPropertyProcess = new FixUnionEntityIllegalPropertyRuntimeProcess(boxFixScene);
        this.columnToRowProcess = new FixEntityColumnToRowProcess(boxFixScene);
    }

    @Override
    public boolean process(FixAbstractEntityProcess abstractEntityProcess, UnionEntity unionEntity, Map<String, AbstractSource> sourcesMap, Map<String, DesigntimeDataObject> designtimeDataObjectMap, Map<String, AbstractEntity> entitysMap, Map<String, Boolean> hasFixEntity) {
        if (unionEntity == null) {
            return true;
        }
        boolean isDeleteEntity = false;
        HashSet<String> allUnionEntityChildPropertyNameSet = new HashSet<String>();
        List<ColumnToRowProperty> columnToRowProperties = unionEntity.getColumnToRowProperties();
        if (columnToRowProperties != null && columnToRowProperties.size() > 0) {
            this.columnToRowProcess.process(unionEntity);
            int len = columnToRowProperties.size();
            for (int i = 0; i < len; ++i) {
                ColumnToRowProperty columnToRowProperty = columnToRowProperties.get(i);
                allUnionEntityChildPropertyNameSet.addAll(columnToRowProperty.getFieldValueNames());
                allUnionEntityChildPropertyNameSet.add(columnToRowProperty.getFieldNameProperty().getName());
            }
        }
        List<Entity> unionEntityChildren = unionEntity.getChildren();
        Iterator<Entity> unionEntityChildrenIterator = unionEntityChildren.iterator();
        while (unionEntityChildrenIterator.hasNext()) {
            Entity unionEntityChild = unionEntityChildrenIterator.next();
            boolean isDeleteEntityChild = this.entityProcess.process(abstractEntityProcess, unionEntityChild, sourcesMap, designtimeDataObjectMap, entitysMap, hasFixEntity);
            if (!isDeleteEntityChild) {
                Map unionEntityChildRelatedBasePropertyMap = MapUtils.collectionToMap(unionEntityChild.getProperties(), (MapUtils.IMapKeySelector)new PropertyRelatedBaseKeySelector());
                allUnionEntityChildPropertyNameSet.addAll(unionEntityChildRelatedBasePropertyMap.keySet());
                continue;
            }
            unionEntityChildrenIterator.remove();
        }
        if (unionEntityChildren.isEmpty()) {
            isDeleteEntity = true;
        } else {
            for (Entity entity : unionEntityChildren) {
                EntityErrorInfo entityErrorInfo = entity.getErrorInfo();
                if (entityErrorInfo != null) {
                    unionEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.UNIONENTITY_CHILDTABLE_HAVE_PROBLEM));
                    continue;
                }
                List<Property> properties = entity.getProperties();
                for (Property property : properties) {
                    Property unionEntityProperty;
                    if (!property.isNotExisted() || (unionEntityProperty = this.findUnionEntityPropertyByName(unionEntity, property.getName())) == null) continue;
                    unionEntityProperty.setNotExisted(true);
                }
            }
            this.fixUnionEntityIllegalPropertyProcess.process(unionEntity, allUnionEntityChildPropertyNameSet);
            this.fixUnionEntityChildProcess(unionEntity);
        }
        return isDeleteEntity;
    }

    private Property findUnionEntityPropertyByName(UnionEntity unionEntity, String propertyName) {
        List<Property> unionEntityProperties = unionEntity.getProperties();
        for (Property property : unionEntityProperties) {
            if (!Objects.equals(property.getName(), propertyName)) continue;
            return property;
        }
        return null;
    }

    private void fixUnionEntityChildProcess(UnionEntity unionEntity) {
        AbstractFixUnionEntityChildProcessor entityChildProcessor = null;
        List<ColumnToRowProperty> colToRows = unionEntity.getColumnToRowProperties();
        List<Entity> childEntities = unionEntity.getChildren();
        boolean childEntityHasCol2Row = false;
        for (Entity childEntity : childEntities) {
            List<ColumnToRowProperty> col2RowProperties = childEntity.getColumnToRowProperties();
            if (!CollectionUtils.isNotEmpty(col2RowProperties)) continue;
            childEntityHasCol2Row = true;
            break;
        }
        entityChildProcessor = null != colToRows && colToRows.size() > 0 || childEntityHasCol2Row ? new FixUnionChildEntityProcess4ColToRow(this.fixScene) : new FixUnionEntityChildRuntimeBaseProcess(this.fixScene);
        entityChildProcessor.fixUnionEntityChild(unionEntity);
    }
}

