/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.common.i18n.Messages;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TO_STRING_DETAIAL_PATTERN_2 = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_TO_STRING_SHORT_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TO_STRING_SHORT_PATTERN_2 = "yyyy/MM/dd";
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.DATE_TO_STRING_SHORT_PATTERN);
        }
    };
    private static final ThreadLocal<DateFormat> dateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.DATE_TO_STRING_DETAIAL_PATTERN);
        }
    };
    private static Pattern timePattern = Pattern.compile("^((20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d)$");

    public static String DateToString(Date source, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(source);
    }

    public static String DateToString(Date date) {
        return dateFormat.get().format(date);
    }

    public static String DateTimeToString(Date date) {
        return dateTimeFormat.get().format(date);
    }

    public static Date stringToDate(String source) throws ParseException {
        return dateFormat.get().parse(source);
    }

    public static Date stringToDateTime(String source) throws ParseException {
        return dateTimeFormat.get().parse(source);
    }

    public static String timeStampToString(long source, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date date = new Date(source * 1000L);
        return simpleDateFormat.format(date);
    }

    public static long dateToTimeStamp(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.getTime() / 1000L;
    }

    public static long dateToMin(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.getTime() / 1000L * 60L;
    }

    public static long dateToHour(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.getTime() / 1000L * 60L * 60L;
    }

    public static long dateToDay(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.getTime() / 1000L * 60L * 60L * 24L;
    }

    public static long dateToMonth(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.getTime() / 1000L * 60L * 60L * 24L * 30L;
    }

    public static long dateToYear(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.getTime() / 1000L * 60L * 60L * 24L * 30L * 12L;
    }

    public static String formatTo(Date date) {
        String result = "";
        long time = new Date().getTime() - date.getTime();
        if ((double)time / 3.1104E10 > 1.0) {
            String v = DateUtils.DateToString(date, "MM");
            String vd = DateUtils.DateToString(date, "dd");
            return DateUtils.DateToString(date, "yyyy") + Messages.getMLS((String)"year", (String)"\u5e74", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + Long.valueOf(v) + Messages.getMLS((String)"month", (String)"\u6708", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + Long.valueOf(vd) + Messages.getMLS((String)"day", (String)"\u65e5", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if ((double)time / 2.592E9 > 1.0 || (double)time / 8.64E7 > 1.0) {
            String v = DateUtils.DateToString(date, "MM");
            String vd = DateUtils.DateToString(date, "dd");
            return Long.valueOf(v) + Messages.getMLS((String)"month", (String)"\u6708", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + Long.valueOf(vd) + Messages.getMLS((String)"day", (String)"\u65e5", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if ((double)time / 3600000.0 > 1.0) {
            return time / 3600000L + Messages.getMLS((String)"hourBefore", (String)"\u5c0f\u65f6\u524d", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if ((double)time / 60000.0 > 1.0) {
            return time / 60000L + Messages.getMLS((String)"minuteBefore", (String)"\u5206\u524d", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        return Messages.getMLS((String)"1minuteBefore", (String)"1\u5206\u949f\u524d", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
    }

    public static Date stringToDate(String source, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.parse(source);
    }

    public static boolean tryToDate(String source) {
        boolean ok = true;
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = source.contains("/") ? new SimpleDateFormat(DATE_TO_STRING_SHORT_PATTERN_2) : new SimpleDateFormat(DATE_TO_STRING_SHORT_PATTERN);
        try {
            simpleDateFormat.parse(source);
        }
        catch (ParseException e) {
            ok = false;
        }
        return ok;
    }

    public static boolean tryToTime(String source) {
        boolean ok = true;
        if (!timePattern.matcher(source).matches()) {
            ok = false;
        }
        return ok;
    }

    public static String currentFormatDate(String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(new Date());
    }

    public static long currentTimeStamp() {
        return System.currentTimeMillis() / 1000L;
    }
}

