/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util.jchardet;

import com.kingdee.bos.qing.data.util.jchardet.nsEUCTWVerifier;
import com.kingdee.bos.qing.data.util.jchardet.nsGB18030Verifier;
import com.kingdee.bos.qing.data.util.jchardet.nsGB2312Verifier;
import com.kingdee.bos.qing.data.util.jchardet.nsUCS2BEVerifier;
import com.kingdee.bos.qing.data.util.jchardet.nsUCS2LEVerifier;
import com.kingdee.bos.qing.data.util.jchardet.nsUTF8Verifier;
import com.kingdee.bos.qing.data.util.jchardet.nsVerifier;

public abstract class nsPSMDetector {
    public static final int ALL = 0;
    public static final int JAPANESE = 1;
    public static final int CHINESE = 2;
    public static final int SIMPLIFIED_CHINESE = 3;
    public static final int TRADITIONAL_CHINESE = 4;
    public static final int KOREAN = 5;
    public static final int NO_OF_LANGUAGES = 6;
    public static final int MAX_VERIFIERS = 16;
    private nsVerifier[] mVerifier;
    private byte[] mState = new byte[16];
    private int[] mItemIdx = new int[16];
    private int mItems;
    private int mClassItems;
    protected boolean mDone;

    public nsPSMDetector() {
        this.initVerifiers(0);
        this.Reset();
    }

    public nsPSMDetector(int paramInt) {
        this.initVerifiers(paramInt);
        this.Reset();
    }

    public nsPSMDetector(int paramInt, nsVerifier[] paramArrayOfnsVerifier) {
        this.mVerifier = paramArrayOfnsVerifier;
        this.mClassItems = paramInt;
        this.Reset();
    }

    public final void Reset() {
        this.mDone = false;
        this.mItems = this.mClassItems;
        for (int i = 0; i < this.mItems; ++i) {
            this.mState[i] = 0;
            this.mItemIdx[i] = i;
        }
    }

    protected final void initVerifiers(int paramInt) {
        boolean i = false;
        int j = paramInt >= 0 && paramInt < 6 ? paramInt : 0;
        this.mVerifier = null;
        if (j == 4) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsEUCTWVerifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (j == 5) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (j == 3) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsGB2312Verifier(), new nsGB18030Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (j == 1) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (j == 2) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsGB2312Verifier(), new nsGB18030Verifier(), new nsEUCTWVerifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        } else if (j == 0) {
            this.mVerifier = new nsVerifier[]{new nsUTF8Verifier(), new nsGB2312Verifier(), new nsGB18030Verifier(), new nsUCS2BEVerifier(), new nsUCS2LEVerifier()};
        }
        if (this.mVerifier != null) {
            this.mClassItems = this.mVerifier.length;
        }
    }

    public abstract void Report(String var1);

    public boolean HandleData(byte[] paramArrayOfByte, int paramInt) {
        for (int i = 0; i < paramInt; ++i) {
            byte b = paramArrayOfByte[i];
            int j = 0;
            while (j < this.mItems) {
                byte k = nsVerifier.getNextState(this.mVerifier[this.mItemIdx[j]], b, this.mState[j]);
                if (k == 2) {
                    this.Report(this.mVerifier[this.mItemIdx[j]].getCharset());
                    this.mDone = true;
                    return this.mDone;
                }
                if (k == 1) {
                    --this.mItems;
                    if (j >= this.mItems) continue;
                    this.mItemIdx[j] = this.mItemIdx[this.mItems];
                    this.mState[j] = this.mState[this.mItems];
                    continue;
                }
                this.mState[j++] = k;
            }
            if (this.mItems <= 1) {
                if (1 == this.mItems) {
                    this.Report(this.mVerifier[this.mItemIdx[0]].getCharset());
                }
                this.mDone = true;
                return this.mDone;
            }
            int m = 0;
            int n = 0;
            for (j = 0; j < this.mItems; ++j) {
                if (this.mVerifier[this.mItemIdx[j]].isUCS2()) continue;
                ++m;
                n = j;
            }
            if (1 != m) continue;
            this.Report(this.mVerifier[this.mItemIdx[n]].getCharset());
            this.mDone = true;
            return this.mDone;
        }
        return this.mDone;
    }

    public void DataEnd() {
        if (this.mDone) {
            return;
        }
        if (this.mItems == 2) {
            if (this.mVerifier[this.mItemIdx[0]].getCharset().equals("GB18030")) {
                this.Report(this.mVerifier[this.mItemIdx[1]].getCharset());
                this.mDone = true;
            } else if (this.mVerifier[this.mItemIdx[1]].getCharset().equals("GB18030")) {
                this.Report(this.mVerifier[this.mItemIdx[0]].getCharset());
                this.mDone = true;
            }
        }
    }

    public String[] getProbableCharsets() {
        if (this.mItems <= 0) {
            String[] arrayOfString = new String[]{"nomatch"};
            return arrayOfString;
        }
        String[] arrayOfString = new String[this.mItems];
        for (int i = 0; i < this.mItems; ++i) {
            arrayOfString[i] = this.mVerifier[this.mItemIdx[i]].getCharset();
        }
        return arrayOfString;
    }
}

