/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableRowDataProcessor;
import com.kingdee.bos.qing.api.customtable.model.ComplexFieldData;
import com.kingdee.bos.qing.api.customtable.model.FieldData;
import com.kingdee.bos.qing.api.customtable.model.FieldMeta;
import com.kingdee.bos.qing.api.customtable.model.FieldType;
import com.kingdee.bos.qing.api.customtable.model.Scene;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.api.customtable.model.TableRowObject;
import com.kingdee.bos.qing.bill.data.provider.ConfigurableBillDataProvider;
import com.kingdee.bos.qing.bill.data.provider.UnConfigurableBillDataProvider;
import com.kingdee.bos.qing.bill.preparedata.DefaultFieldInfoHandler;
import com.kingdee.bos.qing.bill.preparedata.MetaInfoConverter;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.extension.manager.IExtensionClassProvider;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionConfig;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionLoader;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCloseListener;
import com.kingdee.bos.qing.datasource.spec.qs.QingStorageWriterWraper;
import com.kingdee.bos.qing.extension.local.EASExtensionProviderFactory;
import com.kingdee.bos.qing.extension.local.TableDataProcessorGroup;
import com.kingdee.bos.qing.extension.local.TableMetaProcessorGroup;
import com.kingdee.bos.qing.macro.exception.MacroException;
import com.kingdee.bos.qing.preparedata.config.ExtractorConfig;
import com.kingdee.bos.qing.preparedata.exception.BillFormException;
import com.kingdee.bos.qing.preparedata.exception.ComponentConfigException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.IPageDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ComplexField;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.model.Pager;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.web.etl.model.QueryPageParameters;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class QueryDataProvider
implements IPageDataProvider,
IDataSourceCloseListener {
    protected Context bosContext;
    protected MetaInfo metaInfo;
    protected ExtractorConfig config = new ExtractorConfig();
    protected IDataProvider queryExecutor;
    protected QingContext qingContext;
    private QingMeta qingMeta;
    protected QueryPageParameters parameter;
    private Pager pager;
    protected Map<String, FieldData> sharedFieldDatas;
    protected Map<String, String> realRsNameMap = new HashMap<String, String>();
    private ResultSet rowSet;
    private Connection conn;
    private PreparedStatement statement;
    private IQingTableRowDataProcessor rowDataProcessor;
    protected DefaultFieldInfoHandler fieldHandler;

    public QueryDataProvider(QingContext qingContext, QueryPageParameters parameter) {
        this.qingContext = qingContext;
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
        this.bosContext = qingIntegratedContext.getBosContext();
        this.pager = new Pager();
        this.parameter = parameter;
    }

    public static QueryDataProvider newInstance(QingContext qingContext, QueryPageParameters parameter) {
        String dataSourceType = parameter.getData().get("dataSourceType");
        if (dataSourceType == null || !dataSourceType.equals("EntityType")) {
            return new UnConfigurableBillDataProvider(qingContext, parameter);
        }
        return new ConfigurableBillDataProvider(qingContext, parameter);
    }

    @Override
    public MetaInfo getMeta() throws PrepareDataException {
        this.qingMeta = this.buildQingMeta();
        this.prepareQuery();
        this.parseQingMeta();
        return this.metaInfo;
    }

    private void prepareQuery() throws BillFormException {
        try {
            this.queryExecutor = this.initQueryExecutor();
            this.setTotalRowSize();
        }
        catch (Exception e) {
            throw new BillFormException(e);
        }
    }

    private void parseQingMeta() {
        MetaInfoConverter converter = new MetaInfoConverter(this.fieldHandler);
        this.metaInfo = converter.convertFromQingMeta(this.qingMeta);
    }

    protected abstract QingMeta buildQingMeta() throws PrepareDataException;

    protected void processQingMeta(QingMeta qingMeta) throws BillFormException {
        IExtensionClassProvider<IQingTableMetaProcessor> classProvider = EASExtensionProviderFactory.getExtensionClassProvider(IQingTableMetaProcessor.class);
        QingExtensionConfig qingExtensionConfig = new QingExtensionConfig(classProvider);
        QingExtensionLoader metaExtensionLoader = QingExtensionLoader.getExtensionLoader((QingExtensionConfig)qingExtensionConfig);
        List metaProcessors = metaExtensionLoader.getExtensions(new String[]{"com.kingdee.eas.qing.billmeta", qingMeta.getRootKey()});
        TableMetaProcessorGroup groupMetaProcessor = new TableMetaProcessorGroup(metaProcessors);
        HashMap<String, Object> contextDatas = new HashMap<String, Object>();
        contextDatas.put("bosContext", this.bosContext);
        contextDatas.put("qingContext", this.qingContext);
        contextDatas.put("processScene", Scene.EMBBEDED);
        TableMetaKey metaKey = new TableMetaKey(this.parameter.getQueryPK(), contextDatas);
        try {
            groupMetaProcessor.processTableMeta(new TableMetaObject((Object)qingMeta, metaKey));
        }
        catch (Exception e) {
            throw new BillFormException(e.getMessage(), e);
        }
    }

    protected QingMeta getQingMeta() {
        return this.qingMeta;
    }

    protected abstract IDataProvider initQueryExecutor() throws BOSException, ParserException, MacroException, ComponentConfigException;

    private void setTotalRowSize() throws BOSException {
        long totalRowsCount = this.queryExecutor.getRowCount();
        if (this.config.isLimitMaxRows() && totalRowsCount > (long)this.config.getMaxRows()) {
            totalRowsCount = this.config.getMaxRows();
        }
        this.pager.setTotal(this.parameter.getRows(), totalRowsCount);
    }

    private FieldType getFieldType(Field field) {
        FieldType fieldType = FieldType.SIMPLE;
        if (field instanceof ComplexField) {
            fieldType = FieldType.COMPLEX_CUSTOM;
        }
        return fieldType;
    }

    protected void initSharedFieldData() {
        if (null != this.sharedFieldDatas) {
            return;
        }
        List<Field> columnFields = this.qingMeta.getColumns();
        this.sharedFieldDatas = new HashMap<String, FieldData>();
        Map<String, String> originToPureFieldNames = this.fieldHandler.getOriginalAndPureNameRelation();
        for (Field field : columnFields) {
            String associateName = field.getAssociateName().toUpperCase();
            String realRsName = this.realRsNameMap.get(associateName);
            FieldType fieldType = this.getFieldType(field);
            FieldData fieldData = null;
            String upperCaseFullName = this.buildFieldDataFullName(field).toUpperCase();
            String qingFieldKey = originToPureFieldNames.get(upperCaseFullName);
            switch (fieldType) {
                case COMPLEX_CUSTOM: {
                    List<Field> innerFields = ((ComplexField)field).getInnerFields();
                    ArrayList<FieldData> complexInnerFieldDatas = new ArrayList<FieldData>();
                    for (Field inner : innerFields) {
                        String innerFieldFullName = inner.getEntity().toUpperCase() + "." + inner.getName().toUpperCase();
                        String qingInnerFieldKey = originToPureFieldNames.get(innerFieldFullName);
                        complexInnerFieldDatas.add(new FieldData(innerFieldFullName, qingInnerFieldKey, null));
                    }
                    fieldData = new ComplexFieldData(fieldType, realRsName, qingFieldKey, null, complexInnerFieldDatas);
                    break;
                }
                default: {
                    fieldData = new FieldData(realRsName, qingFieldKey, null);
                }
            }
            fieldData.setFieldMeta(new FieldMeta((Object)field, upperCaseFullName));
            fieldData.setNotOrmField(!field.isSupportOrm());
            this.sharedFieldDatas.put(upperCaseFullName, fieldData);
        }
    }

    protected String buildFieldDataFullName(Field field) {
        return field.getEntity() + "." + field.getName();
    }

    private void queryData() throws SQLException, BOSException, SqlTranslateException {
        this.conn = EJBFactory.getConnection((Context)this.bosContext);
        String sql = this.queryExecutor.getSQL();
        sql = KSqlUtil.optimize((String)sql);
        this.statement = this.conn.prepareStatement(sql);
        this.rowSet = this.statement.executeQuery();
        this.rowDataProcessor = this.getTableDataProcessor(this.qingContext);
        this.initRealRsNames();
        this.initSharedFieldData();
    }

    private void initRealRsNames() {
        SelectorItemCollection collection = this.queryExecutor.getObjectView().getSelector();
        int fieldSize = collection.size();
        for (int colIndex = 1; colIndex <= fieldSize; ++colIndex) {
            String fieldName;
            SelectorItemInfo itemInfo = collection.get(colIndex - 1);
            String realRsName = fieldName = itemInfo.getPropertyName();
            if (fieldName != null && fieldName.length() >= 30) {
                int tempCol = colIndex - 1;
                realRsName = fieldName.substring(0, Math.min(fieldName.length(), 30 - String.valueOf(tempCol).length())) + tempCol;
            }
            this.realRsNameMap.put(fieldName, realRsName);
        }
    }

    protected List<Object[]> getDatas(int start, int length) throws SQLException, BOSException, SqlTranslateException {
        if (null == this.rowSet) {
            this.queryData();
        }
        LinkedList<Object[]> dataList = new LinkedList<Object[]>();
        HashMap targetMap = new HashMap();
        while (this.rowSet.next()) {
            this.bindFieldValue(this.rowSet);
            TableRowObject rowObj = new TableRowObject(this.sharedFieldDatas);
            this.rowDataProcessor.processRow(rowObj);
            targetMap.clear();
            rowObj.flushToMap(targetMap);
            List allFields = this.metaInfo.getFieldNames();
            Object[] rowDatas = new Object[allFields.size()];
            for (int i = 0; i < allFields.size(); ++i) {
                rowDatas[i] = targetMap.get(allFields.get(i));
            }
            dataList.add(rowDatas);
            if (dataList.size() != length) continue;
            break;
        }
        return dataList;
    }

    @Override
    public Pager nextPage() throws BillFormException {
        this.pager.nextPage();
        int start = this.pager.getStartIndex();
        int length = this.pager.getLengthLimit();
        List<Object[]> result = null;
        if (length == 0) {
            result = Collections.emptyList();
        } else {
            try {
                result = this.getDatas(start, length);
            }
            catch (Exception e) {
                throw new BillFormException(e.getMessage(), e);
            }
        }
        this.pager.setData(result);
        return this.pager;
    }

    protected IQingTableRowDataProcessor getTableDataProcessor(QingContext qingContext) {
        IExtensionClassProvider<IQingTableRowDataProcessor> classProvider = EASExtensionProviderFactory.getExtensionClassProvider(IQingTableRowDataProcessor.class);
        QingExtensionConfig config = new QingExtensionConfig(classProvider);
        QingExtensionLoader extensionLoader = QingExtensionLoader.getExtensionLoader((QingExtensionConfig)config);
        List processors = extensionLoader.getExtensions(new String[]{this.qingMeta.getRootKey()});
        TableDataProcessorGroup rowDataProcessor = new TableDataProcessorGroup(processors);
        HashMap<String, Object> dataContext = new HashMap<String, Object>();
        dataContext.put("bosContext", ((QingIntegratedContext)qingContext).getBosContext());
        dataContext.put("embeddedMetaInfo", this.metaInfo);
        dataContext.put("processScene", Scene.EMBBEDED);
        rowDataProcessor.prepareParamDatas(dataContext);
        return rowDataProcessor;
    }

    protected void bindFieldValue(ResultSet rowSet) throws SQLException {
        for (FieldData fieldData : this.sharedFieldDatas.values()) {
            if (fieldData.isNotOrmField()) {
                fieldData.bindRawValue(null);
                continue;
            }
            Object value = rowSet.getObject(fieldData.getRawFieldName());
            fieldData.bindRawValue(null);
            FieldMeta meta = fieldData.getFieldMeta();
            Field field = (Field)meta.getOriginalField(Field.class);
            Map<String, String> enumValues = field.getEnumItems();
            if (enumValues != null && enumValues.size() > 0) {
                String enumDescValue = enumValues.get(String.valueOf(value));
                fieldData.bindRawValue((Object)enumDescValue);
                continue;
            }
            fieldData.bindRawValue(value);
        }
    }

    @Override
    public void dispose() throws PrepareDataException {
        CloseUtil.close((ResultSet)this.rowSet);
        CloseUtil.close((Statement)this.statement);
        CloseUtil.close((Connection)this.conn);
    }

    public void doCloseBefore(QingStorageWriterWraper writerWraper) {
    }
}

