/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.model;

import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.util.QueryUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BillField {
    private String key;
    private String name;
    private String entity;
    private String refEntity;
    private String fieldType;
    private static final Pattern REF_NAME = Pattern.compile("\\([[a-zA-Z]\\.[a-zA-Z]]*\\)", 32);

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getRefEntity() {
        return this.refEntity;
    }

    public void setRefEntity(String refEntity) {
        this.refEntity = refEntity;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public Field toField() {
        Field field = new Field();
        field.setName(this.key);
        Matcher matcher = REF_NAME.matcher(this.refEntity);
        if (matcher.find()) {
            int start = matcher.start();
            field.setAlias(this.refEntity.substring(0, start));
            int end = matcher.end();
            field.setAssociateName(this.refEntity.substring(start + 1, end - 1));
        } else {
            int index = this.refEntity.lastIndexOf(40);
            field.setAlias(this.refEntity.substring(0, index));
            int lastIndex = this.refEntity.lastIndexOf(41);
            field.setAssociateName(this.refEntity.substring(index + 1, lastIndex));
        }
        field.setFieldType(QueryUtil.parseQingFieldType(this.fieldType).toNumber());
        field.setEntity(this.entity);
        field.setRefEntity(this.refEntity);
        return field;
    }
}

