/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.preparedata;

import com.kingdee.bos.qing.bill.preparedata.IMetaFieldNameBuilder;
import com.kingdee.bos.qing.bill.preparedata.IMetaInfoFieldHandler;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ComplexField;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.util.FieldTypeUtil;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultFieldInfoHandler
implements IMetaInfoFieldHandler {
    protected Map<String, Integer> repeatedNameIndex;
    protected Map<String, String> originAndPureNameRelation;
    protected QingMeta qingMeta;
    private IMetaFieldNameBuilder fieldNameBuilder;

    public DefaultFieldInfoHandler(IMetaFieldNameBuilder fieldNameBuilder) {
        this.fieldNameBuilder = fieldNameBuilder;
    }

    @Override
    public void doPrepareBefore(QingMeta qingMeta) {
        this.qingMeta = qingMeta;
        this.repeatedNameIndex = new HashMap<String, Integer>();
        this.originAndPureNameRelation = new HashMap<String, String>();
    }

    @Override
    public void handleFieldInfo(MetaInfo metaInfo, Field field) {
        String fullName = field.getEntity() + "." + field.getName();
        String upperCaseFullName = fullName.toUpperCase();
        String pureFieldName = NameUtil.getPureName((String)this.fieldNameBuilder.buildFieldName(field), this.repeatedNameIndex);
        this.originAndPureNameRelation.put(upperCaseFullName, pureFieldName);
        metaInfo.addField(pureFieldName, field.getAlias(), FieldTypeUtil.changeQingFieldTypeToDataType(field.getFieldType()), this.isNeedHide(field));
        if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            List<Field> innerFields = complexField.getInnerFields();
            for (Field innerField : innerFields) {
                String innerFieldFullName = innerField.getEntity() + "." + innerField.getName();
                String upperCaseInnerFullName = innerFieldFullName.toUpperCase();
                String pureInnerFieldName = NameUtil.getPureName((String)innerFieldFullName, this.repeatedNameIndex);
                this.originAndPureNameRelation.put(upperCaseInnerFullName, pureInnerFieldName);
                metaInfo.addField(pureInnerFieldName, innerField.getAlias(), FieldTypeUtil.changeQingFieldTypeToDataType(innerField.getFieldType()), this.isNeedHide(innerField));
            }
        }
    }

    protected boolean isNeedHide(Field field) {
        return field.isHide();
    }

    @Override
    public Map<String, String> getOriginalAndPureNameRelation() {
        return this.originAndPureNameRelation;
    }

    @Override
    public void doFinishAfter(MetaInfo metaInfo) {
    }
}

