/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.preparedata;

import com.kingdee.bos.qing.bill.preparedata.IMetaInfoConverter;
import com.kingdee.bos.qing.bill.preparedata.IMetaInfoFieldHandler;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldItem;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ComplexField;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetaInfoConverter
implements IMetaInfoConverter {
    private IMetaInfoFieldHandler metaInfoHandler;

    public MetaInfoConverter(IMetaInfoFieldHandler metaInfoHandler) {
        this.metaInfoHandler = metaInfoHandler;
    }

    @Override
    public MetaInfo convertFromQingMeta(QingMeta qingMeta) {
        MetaInfo metaInfo = new MetaInfo();
        this.metaInfoHandler.doPrepareBefore(qingMeta);
        List<Field> columns = qingMeta.getColumns();
        for (Field field : columns) {
            if (!field.isSupportQingDataModel()) continue;
            this.metaInfoHandler.handleFieldInfo(metaInfo, field);
        }
        this.metaInfoHandler.doFinishAfter(metaInfo);
        this.bulidMetaInfoSubView(metaInfo, qingMeta);
        return metaInfo;
    }

    private void bulidMetaInfoSubView(MetaInfo metaInfo, QingMeta qingMeta) {
        List<ComplexField> complexFields = this.getComplexFields(qingMeta);
        if (complexFields.isEmpty()) {
            return;
        }
        metaInfo.setSubViews(new ArrayList());
        this.bulidDSMetaFieldItemList(qingMeta.getColumns(), metaInfo);
    }

    private List<ComplexField> getComplexFields(QingMeta qingMeta) {
        ArrayList<ComplexField> complexFields = new ArrayList<ComplexField>();
        List<Field> fields = qingMeta.getColumns();
        for (Field field : fields) {
            if (!(field instanceof ComplexField)) continue;
            complexFields.add((ComplexField)field);
        }
        return complexFields;
    }

    public void bulidDSMetaFieldItemList(List<Field> columns, MetaInfo metaInfo) {
        ArrayList<DSMetaFieldItem> dateSubViewItems = new ArrayList<DSMetaFieldItem>();
        ArrayList<DSMetaFieldItem> stringSubViewItems = new ArrayList<DSMetaFieldItem>();
        ArrayList<DSMetaFieldItem> numberSubViewItems = new ArrayList<DSMetaFieldItem>();
        ArrayList<DSMetaFieldItem> dSMetaFieldItemList = new ArrayList<DSMetaFieldItem>();
        if (!CollectionUtils.isEmpty(columns)) {
            Map<String, String> orginalAndPureNameMap = this.metaInfoHandler.getOriginalAndPureNameRelation();
            for (Field field : columns) {
                if (!field.isSupportQingDataModel()) continue;
                int fieldType = field.getFieldType();
                QingFieldType qingFieldType = QingFieldType.valueOfNumber(fieldType);
                String fullFieldName = field.getEntity() + "." + field.getName();
                String pureName = orginalAndPureNameMap.get(fullFieldName.toUpperCase());
                switch (qingFieldType) {
                    case Date: 
                    case DateTime: {
                        dateSubViewItems.add(new DSMetaFieldItem(pureName));
                        break;
                    }
                    case String: 
                    case Boolean: {
                        stringSubViewItems.add(new DSMetaFieldItem(pureName));
                        break;
                    }
                    case Int: 
                    case Number: {
                        numberSubViewItems.add(new DSMetaFieldItem(pureName));
                    }
                }
                if (!(field instanceof ComplexField)) continue;
                DSMetaEntitySubView subView = new DSMetaEntitySubView(pureName, field.getAlias(), 1);
                this.buildFlexFieldSubView(subView, (ComplexField)field);
                metaInfo.getSubViews().add(subView);
            }
        }
        dSMetaFieldItemList.addAll(dateSubViewItems);
        dSMetaFieldItemList.addAll(stringSubViewItems);
        dSMetaFieldItemList.addAll(numberSubViewItems);
        metaInfo.setViewItems(dSMetaFieldItemList);
    }

    private void buildFlexFieldSubView(DSMetaEntitySubView subView, ComplexField complexField) {
        ArrayList<DSMetaFieldItem> dateSubViewItems = new ArrayList<DSMetaFieldItem>();
        ArrayList<DSMetaFieldItem> stringSubViewItems = new ArrayList<DSMetaFieldItem>();
        ArrayList<DSMetaFieldItem> numberSubViewItems = new ArrayList<DSMetaFieldItem>();
        ArrayList<DSMetaFieldItem> dSMetaFieldItemList = new ArrayList<DSMetaFieldItem>();
        List<Field> innerFields = complexField.getInnerFields();
        Map<String, String> orginalAndPureNameMap = this.metaInfoHandler.getOriginalAndPureNameRelation();
        for (Field innerField : innerFields) {
            String innerFieldFullName = innerField.getEntity() + "." + innerField.getName();
            String pureFieldName = orginalAndPureNameMap.get(innerFieldFullName.toUpperCase());
            int innerFieldType = innerField.getFieldType();
            QingFieldType innerQingFieldType = QingFieldType.valueOfNumber(innerFieldType);
            switch (innerQingFieldType) {
                case Date: 
                case DateTime: {
                    dateSubViewItems.add(new DSMetaFieldItem(pureFieldName));
                    break;
                }
                case String: 
                case Boolean: {
                    stringSubViewItems.add(new DSMetaFieldItem(pureFieldName));
                    break;
                }
                case Int: 
                case Number: {
                    numberSubViewItems.add(new DSMetaFieldItem(pureFieldName));
                }
            }
        }
        dSMetaFieldItemList.addAll(dateSubViewItems);
        dSMetaFieldItemList.addAll(stringSubViewItems);
        dSMetaFieldItemList.addAll(numberSubViewItems);
        subView.addAllViewItem(dSMetaFieldItemList);
    }
}

