/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.dao.impl;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.dao.impl.ParameterSetter;
import com.kingdee.bos.qing.common.dao.impl.TXManageImpl;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.UUID;

public class DBExcuterImpl
implements IDBExcuter {
    private static ThreadLocal<DBExcuterImpl> threadLocal = new ThreadLocal();
    private TXManageImpl tx;
    private boolean pmdKnownBroken = false;

    public DBExcuterImpl(TXManageImpl tx) {
        this.tx = tx;
        threadLocal.set(this);
    }

    public static IDBExcuter getThreadLocalDBExcuter() {
        return threadLocal.get();
    }

    public String genStringId(String tableName) {
        return UUID.randomUUID().toString();
    }

    public String[] genStringId(String tableName, int size) {
        String[] ids = new String[size];
        for (int index = 0; index < size; ++index) {
            ids[index] = this.genStringId(tableName);
        }
        return ids;
    }

    private void setParams(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        ParameterMetaData pmd = null;
        if (!this.pmdKnownBroken) {
            int paramsCount;
            pmd = stmt.getParameterMetaData();
            int stmtCount = pmd.getParameterCount();
            int n = paramsCount = params == null ? 0 : params.length;
            if (stmtCount != paramsCount) {
                throw new SQLException("Wrong number of parameters: expected " + stmtCount + ", was given " + paramsCount);
            }
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param != null) {
                ParameterSetter.set(stmt, param, i + 1);
                continue;
            }
            int sqlType = 12;
            if (!this.pmdKnownBroken) {
                try {
                    sqlType = pmd.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    this.pmdKnownBroken = true;
                }
            }
            stmt.setNull(i + 1, sqlType);
        }
    }

    private void debugSQl(String sql, Object[] params) {
        if (LogUtil.isDebugEnabled()) {
            StringBuffer debugMessage = new StringBuffer("\u6267\u884csql:\n");
            debugMessage.append("\t" + sql + "\n");
            debugMessage.append("params:\n");
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param != null) {
                    debugMessage.append("\t" + param + "\n");
                    continue;
                }
                debugMessage.append("\tnull\n");
            }
            LogUtil.debug((String)debugMessage.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection conn, String sql, Object[] params) throws SQLException {
        this.debugSQl(sql, params);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params);
            ps.execute();
        }
        finally {
            CloseUtil.close((Statement)ps);
            CloseUtil.close(rs);
        }
    }

    public void execute(String sql, Object[] params) throws SQLException {
        Connection conn = this.tx.getConn();
        this.execute(conn, sql, params);
    }

    public void executeBatch(String sql, List<Object[]> params) throws SQLException {
        Connection conn = this.tx.getConn();
        for (Object[] param : params) {
            this.execute(conn, sql, param);
        }
    }

    public <T> T query(String sql, Object[] params, ResultHandler<T> resultSetHandler) throws SQLException {
        Object object;
        this.debugSQl(sql, params);
        Connection conn = this.tx.getConn();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params);
            rs = ps.executeQuery();
            object = resultSetHandler.handle(rs);
        }
        catch (SQLException e) {
            try {
                LogUtil.debug((String)("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25!sql:" + sql + "\t params:" + params.toString()));
                throw e;
            }
            catch (Throwable throwable) {
                CloseUtil.close((Statement)ps);
                CloseUtil.close(rs);
                if (!this.tx.isInTX()) {
                    this.tx.closeConn();
                }
                throw throwable;
            }
        }
        CloseUtil.close((Statement)ps);
        CloseUtil.close((ResultSet)rs);
        if (!this.tx.isInTX()) {
            this.tx.closeConn();
        }
        return (T)object;
    }

    public Object createSqlParameterBytes(byte[] buf, int offset, int length) {
        if (buf == null) {
            return null;
        }
        byte[] subBlock = new byte[length];
        System.arraycopy(buf, offset, subBlock, 0, length);
        return subBlock;
    }

    public void executeBatchInsert(String sql, List<List<Object>> paramsList, int maxBatchInsertNumbers) throws SQLException {
        if (maxBatchInsertNumbers < 1) {
            maxBatchInsertNumbers = 1000;
        }
        Connection conn = this.tx.getConn();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            int len = paramsList.size();
            for (int i = 0; i < len; ++i) {
                List<Object> params = paramsList.get(i);
                this.setParams(ps, params.toArray());
                ps.addBatch();
                if (i % maxBatchInsertNumbers != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            if (paramsList.size() % maxBatchInsertNumbers != 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            LogUtil.debug((String)("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25!sql:" + sql + "\t params:" + paramsList.toString()));
            throw e;
        }
        finally {
            CloseUtil.close((Statement)ps);
        }
    }
}

