/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl.worktime;

import com.kingdee.bos.qing.common.grammar.funcimpl.WorkTimeFunctions;
import java.math.BigDecimal;
import java.util.Calendar;

public class WorkTimeCalculator
implements WorkTimeFunctions.IWorkTimeCalculator {
    protected static final long SECOND_MILLIS = 1000L;
    protected static final long MINITE_MILLIS = 60000L;
    protected static final long HOUR_MILLIS = 3600000L;
    protected static final long DAY_MILLIS = 86400000L;

    public Double workHour(Calendar fromTimestamp, Calendar toTimestamp, String orgNumber) {
        long total = toTimestamp.getTimeInMillis() - fromTimestamp.getTimeInMillis();
        BigDecimal bigDecimal = this.calWorkTime(total, TimeTypeEnum.HOUR);
        return bigDecimal.doubleValue();
    }

    public Integer workDay(Calendar fromTimestamp, Calendar toTimestamp, String orgNumber) {
        long total = toTimestamp.getTimeInMillis() - fromTimestamp.getTimeInMillis();
        BigDecimal bigDecimal = this.calWorkTime(total, TimeTypeEnum.DAY);
        return bigDecimal.intValue();
    }

    protected BigDecimal calWorkTime(long total, TimeTypeEnum typeEnum) {
        BigDecimal resultData = null;
        switch (typeEnum) {
            case DAY: {
                resultData = BigDecimal.valueOf(total).divide(BigDecimal.valueOf(86400000L), 2, 0);
                break;
            }
            case HOUR: {
                resultData = BigDecimal.valueOf(total).divide(BigDecimal.valueOf(3600000L), 2, 0);
                break;
            }
        }
        return resultData;
    }

    protected static enum TimeTypeEnum {
        HOUR,
        DAY;

    }
}

