/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.customservice;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.publish.lapp.domain.LappContextDomain;
import com.kingdee.bos.qing.publish.lapp.model.LappUser;
import com.kingdee.bos.qing.publish.lapp.util.LappContextUtils;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfigVO;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.dingding.DingDingRobotPushAppInfo;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.wxqyh.WxqyhRobotPushAppInfo;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissonCloudServiceAccount;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.URLUtil;
import com.kingdee.portal.biz.common.util.XTServiceConfig;
import com.kingdee.util.ConfigurationItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LappStrategyImpl
implements ILappStrategy {
    private static final String APP_NAME = "\u8f7b\u5206\u6790";
    private static final String CORPID = "corpid";
    private static final String AGENTID = "agentid";
    private static final String APPKEY = "appkey";

    public String getId() {
        return ILappStrategy.class.getName();
    }

    public MissonCloudServiceAccount getMissonCloudServiceAccount() {
        MissonCloudServiceAccount serviceAccount = null;
        if (this.getMissionCloudProperties() == null) {
            return serviceAccount;
        }
        String pushServerUrl = this.getMissionCloudProperties().get("pushServerUrl");
        String sid = this.getMissionCloudProperties().get("sid");
        String accessToken = this.getMissionCloudProperties().get("accessToken");
        String appKey = this.getMissionCloudProperties().get("appKey");
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)pushServerUrl) && org.apache.commons.lang.StringUtils.isNotEmpty((String)sid) && org.apache.commons.lang.StringUtils.isNotEmpty((String)accessToken) && org.apache.commons.lang.StringUtils.isNotEmpty((String)appKey)) {
            serviceAccount = new MissonCloudServiceAccount();
            serviceAccount.setPushServerUrl(pushServerUrl);
            serviceAccount.setSid(sid);
            serviceAccount.setAccessToken(accessToken);
            serviceAccount.setAppKey(appKey);
        }
        return serviceAccount;
    }

    private Map<String, String> getWxqyhProperties() {
        Map wxqyhProperties = null;
        ConfigurationItem configurationItem = XTServiceConfig.getInstance().getConfigurationItemByPath("QingLightAPP");
        if (configurationItem != null && (configurationItem = configurationItem.getChild(LappContext.AppType.wxqyh.toString())) != null) {
            wxqyhProperties = configurationItem.getProperties();
        }
        return wxqyhProperties;
    }

    private Map<String, String> getMissionCloudProperties() {
        Map missionCloudProperties = null;
        ConfigurationItem configurationItem = XTServiceConfig.getInstance().getConfigurationItemByPath("QingLightAPP");
        if (configurationItem != null && (configurationItem = configurationItem.getChild(LappContext.AppType.missioncloud.toString())) != null) {
            missionCloudProperties = configurationItem.getProperties();
        }
        return missionCloudProperties;
    }

    public WxqyhRobotPushAppInfo getWxqyhAppInfo(IDBExcuter dbExcuter) {
        WxqyhRobotPushAppInfo wxqyhRobotPushAppInfo = new WxqyhRobotPushAppInfo();
        Map<String, String> wxqyhProperties = this.getWxqyhProperties();
        if (wxqyhProperties != null) {
            wxqyhRobotPushAppInfo.setCorpId(wxqyhProperties.get("corpId"));
            wxqyhRobotPushAppInfo.setAgentId(wxqyhProperties.get("agentId"));
        }
        return wxqyhRobotPushAppInfo;
    }

    public DingDingRobotPushAppInfo getDingDingAppInfo(IDBExcuter dbExcuter) {
        return new DingDingRobotPushAppInfo();
    }

    public String genWxqyhOAuth2Url(String sourceUrl, IDBExcuter dbExcuter) {
        WxqyhRobotPushAppInfo wxqyhAppInfo = this.getWxqyhAppInfo(dbExcuter);
        sourceUrl = URLUtil.appendParamToUrl((String)sourceUrl, (String)CORPID, (String)wxqyhAppInfo.getCorpId());
        sourceUrl = URLUtil.appendParamToUrl((String)sourceUrl, (String)AGENTID, (String)wxqyhAppInfo.getAgentId());
        try {
            sourceUrl = URLEncoder.encode(sourceUrl, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        String oAuth2Url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + wxqyhAppInfo.getCorpId() + "&redirect_uri=" + sourceUrl + "&response_type=code&scope=snsapi_base&state=STATE#wechat_redirect";
        return oAuth2Url;
    }

    public String genDingDingOAuth2Url(String sourceUrl, IDBExcuter dbExcuter) {
        return sourceUrl;
    }

    public String getYzjEid(QingContext qingContext) {
        return LappContextUtils.getYzjEid(qingContext);
    }

    public String addExtraParamsToUrl(String url) {
        return url;
    }

    public LappContext getLappConext(List<PublishLappConfigVO> publishLappConfigVOs, QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, IScheduleEngine scheduleEngine) {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        LappContextDomain lappContextDomain = new LappContextDomain(qingContext, dbExcuter, tx, scheduleEngine);
        return lappContextDomain.getLappContext(ctx, null, publishLappConfigVOs);
    }

    public boolean hasConfigOpenIdByUserIdAndAppType(String userId, String appType, QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, IScheduleEngine scheduleEngine) {
        LappContextDomain lappContextDomain = new LappContextDomain(qingContext, dbExcuter, tx, scheduleEngine);
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId);
        Context bosContext = ((QingIntegratedContext)qingContext).getBosContext();
        Map<String, List<LappUser>> map = lappContextDomain.getAllLappContextsByUserIds(bosContext, userIds);
        List<LappUser> lappUsers = map.get(userId);
        if (lappUsers != null) {
            for (LappUser lappUser : lappUsers) {
                LappContext.AppType appTypeEnum = LappContext.AppType.valueOf((String)appType);
                if (appTypeEnum == null || !lappUser.getLappUserType().equals(appTypeEnum.toPersistance().toPersistance()) || !StringUtils.isNotBlank((CharSequence)lappUser.getLappUserId())) continue;
                return true;
            }
        }
        return false;
    }
}

