/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.customservice;

import com.kingdee.bos.qing.preset.strategy.IQingPresetStrategy;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PresetStrategyImpl
implements IQingPresetStrategy {
    private String path;
    private String mapPath;
    private String embeddedPath;
    private static final String PKG_FOLDER = "pkg";
    private static final String MAP_FOLDER = "map";
    private static final String EMBEDDED_PKG_FOLDER = "embedded";

    public String getId() {
        return IQingPresetStrategy.class.getName();
    }

    public String getPath() {
        if (this.path == null) {
            String easHomePath = System.getProperty("EAS_HOME");
            this.path = easHomePath + "/server/deploy/ctrlhome" + File.separator + "QingPreset" + File.separator + PKG_FOLDER;
        }
        return this.path;
    }

    public String getEmbeddedPath() {
        if (this.embeddedPath == null) {
            String easHomePath = System.getProperty("EAS_HOME");
            this.embeddedPath = easHomePath + "/server/deploy/ctrlhome" + File.separator + "QingPreset" + File.separator + EMBEDDED_PKG_FOLDER;
        }
        return this.embeddedPath;
    }

    public String getMapPath() {
        if (this.mapPath == null) {
            String easHomePath = System.getProperty("EAS_HOME");
            this.mapPath = easHomePath + "/server/deploy/ctrlhome" + File.separator + "QingPreset" + File.separator + MAP_FOLDER;
        }
        return this.mapPath;
    }

    public Set<String> getPkgDirectorys(String path) throws IOException {
        HashSet<String> pkgDirectorys = new HashSet<String>();
        LogUtil.info((String)("qing preset directory:" + path));
        File pkgFile = new File(path);
        if (pkgFile != null && pkgFile.listFiles() != null) {
            for (File file : pkgFile.listFiles()) {
                if (file.isDirectory()) {
                    LogUtil.info((String)("qing preset directory:" + file.getPath()));
                    String directoryName = file.getName();
                    pkgDirectorys.add(directoryName);
                    continue;
                }
                LogUtil.error((String)("qing preset error \u6587\u4ef6\u653e\u7f6e\u9519\u8bef, directory:" + file.getPath()));
            }
        } else {
            LogUtil.error((String)"qing preset error \u9884\u7f6e\u6587\u4ef6\u5939\u4e0b\u6ca1\u6709\u4e00\u4e2a\u6587\u4ef6\u3001\u6587\u4ef6\u5939\u6216\u8005\u9884\u7f6e\u6587\u4ef6\u5939\u88ab\u5220\u9664\u4e86");
        }
        return pkgDirectorys;
    }

    public InputStream getFileInputStream(String fileName) {
        File file = new File(fileName);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LogUtil.error((String)"qing preset getFileInputStream error", (Throwable)e);
            return null;
        }
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public boolean verifyProductName(String productName) {
        return true;
    }

    public List<URL> getJarUrls(String path) throws IOException {
        File file = new File(path);
        ArrayList<URL> urls = new ArrayList<URL>(2);
        if (!file.isDirectory() && file.exists()) {
            URL url = file.toURL();
            urls.add(url);
        }
        return urls;
    }

    public boolean ignoreExecuteInProduct(String ignoreProductName) {
        return false;
    }
}

