/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.extReport.domain;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dashboard.extReport.dao.DsbExtReportDao;
import com.kingdee.bos.qing.dashboard.extReport.exception.DsbExtReportException;
import com.kingdee.bos.qing.dashboard.extReport.model.ExtReportInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.List;

public class DsbExtReportDomain {
    private DsbExtReportDao extReportDao;
    private IDBExcuter dbExcuter;
    private QingContext qingCtx;

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setQingContext(QingContext qingCtx) {
        this.qingCtx = qingCtx;
    }

    private DsbExtReportDao getDsbExtReportDao() {
        if (this.extReportDao == null) {
            this.extReportDao = new DsbExtReportDao(this.dbExcuter);
        }
        return this.extReportDao;
    }

    public List<ExtReportInfo> getReportList(String reportType) throws SQLException, DsbExtReportException {
        String userId = this.qingCtx.getUserId();
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingCtx;
        Context ctx = qingIntegratedContext.getBosContext();
        String orgId = ((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString();
        try {
            if ("modul".equalsIgnoreCase(reportType)) {
                return this.getDsbExtReportDao().getReportModulList(ctx, orgId, userId);
            }
            if ("authorized".equalsIgnoreCase(reportType)) {
                return this.getDsbExtReportDao().getAuthorizedReportList(ctx, orgId, userId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            throw new DsbExtReportException(e.getCause(), 900001001);
        }
        return null;
    }

    public boolean hasPermissionByName(String name) throws DsbExtReportException {
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingCtx;
        Context ctx = qingIntegratedContext.getBosContext();
        return DsbExtReportDomain.hasPermission(ctx, name);
    }

    private static boolean hasPermission(Context ctx, String permissonName) throws DsbExtReportException {
        if (ctx == null) {
            return false;
        }
        try {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            ObjectUuidPK orgPK = new ObjectUuidPK(currentOrgUnit.getId());
            return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissonName);
        }
        catch (Exception e) {
            throw new DsbExtReportException(e.getMessage(), 900001002);
        }
    }
}

