/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.easmeta;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.Scene;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.cache.LinkageFormInfo;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.BizMetaUtil;
import com.kingdee.bos.qing.data.domain.DesignObjectBuilder;
import com.kingdee.bos.qing.data.domain.entityparser.EntityObjectInfoParser;
import com.kingdee.bos.qing.data.domain.entityparser.RelationshipEntityObject;
import com.kingdee.bos.qing.data.domain.exception.DataEntityException;
import com.kingdee.bos.qing.data.domain.exception.DataMetaException;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.easmeta.AbstractMetaSourceDomain;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.EntityJoinCollectionBuilder;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.RTQueryJoinCollectionBuilder;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.MetaSource;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.linkage.ILinkageSourceSupporter;
import com.kingdee.bos.qing.linkage.LinkageSourceDomainFactory;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LinkageFormInfoHelper;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntitySourceDomain
extends AbstractMetaSourceDomain
implements ILinkageSourceSupporter {
    private static Map<String, AbstractNode> cacheRootMetaNode = new HashMap<String, AbstractNode>();

    public static void regist() {
        EntitySourceDomain entitySourceDomain = new EntitySourceDomain();
        LinkageSourceDomainFactory.setLinkageSourceDomain((String)MetaSource.MetaType.EASEntity.name(), (ILinkageSourceSupporter)entitySourceDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        this.checkEASPermission(qingContext);
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        String language = ctx.getLocale().toString();
        AbstractNode rootMetaNode = cacheRootMetaNode.get(language);
        if (rootMetaNode == null) {
            Map<String, AbstractNode> map = cacheRootMetaNode;
            synchronized (map) {
                rootMetaNode = cacheRootMetaNode.get(language);
                if (rootMetaNode != null) {
                    return rootMetaNode;
                }
                IBriefViewTreeNode rootNode = BizMetaUtil.getEntityTreeRootNode(ctx);
                rootMetaNode = this.convertToQingNode(rootNode, MetaSource.MetaType.EASEntity.name());
                cacheRootMetaNode.put(language, rootMetaNode);
            }
        }
        return rootMetaNode;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractSourceException, AbstractQingIntegratedException {
        PreviewDataModel result = null;
        try {
            result = super.getPreviewData(qingContext, runtimeEntity, rows);
        }
        catch (DataMetaException e) {
            String msg = "preview entity " + e.getMessage();
            throw DataEntityException.fail2Preview((Throwable)((Object)e), msg);
        }
        return result;
    }

    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String associateName) throws AbstractSourceException, AbstractQingIntegratedException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        EntityObjectInfo eoi = (EntityObjectInfo)this.getMetaInfo(ctx, associateName);
        QingMeta qingMeta = new QingMeta();
        try {
            qingMeta.setCoreBaseBill(this.isCoreBillEntryEntity(eoi));
            RelationshipEntityObject relationshipEntitys = new RelationshipEntityObject(eoi, null, null);
            EntityObjectInfoParser entityParser = new EntityObjectInfoParser();
            entityParser.parseEntityInfo(relationshipEntitys, ctx, qingMeta);
            IQingTableMetaProcessor metaProcessor = this.getTableMetaProcessor(associateName);
            HashMap<String, Object> contextDatas = new HashMap<String, Object>();
            contextDatas.put("bosContext", ctx);
            contextDatas.put("qingContext", qingContext);
            contextDatas.put("processScene", Scene.SUBJECT);
            TableMetaKey metaKey = new TableMetaKey(associateName, contextDatas);
            metaProcessor.processTableMeta(new TableMetaObject((Object)qingMeta, metaKey));
        }
        catch (Exception e) {
            throw DataMetaException.fail2Modeling(e, "process qing meta error");
        }
        return new DesignObjectBuilder().buildFromQingMeta(qingMeta, source);
    }

    @Override
    protected RTQueryJoinCollectionBuilder getJoinCollectionBuilder(RuntimeEntity runtimeEntity, Context ctx) {
        return new EntityJoinCollectionBuilder(ctx, runtimeEntity);
    }

    private boolean isCoreBillEntryEntity(EntityObjectInfo entity) {
        if (entity.getBaseEntity() != null) {
            if (entity.getBaseEntity().getName().equals("CoreBillEntryBase")) {
                return true;
            }
            return this.isCoreBillEntryEntity(entity.getBaseEntity());
        }
        return false;
    }

    @Override
    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, AbstractQingIntegratedException {
        try {
            super.extractData(qingContext, dataSourceWriter, runtimeEntity, progressProcessor);
        }
        catch (DataMetaException e) {
            String msg = "extract etity " + e.getMessage();
            throw DataEntityException.fail2Extract((Throwable)((Object)e), msg);
        }
        return null;
    }

    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
    }

    @Override
    protected AbstractMetaDataValue getMetaInfo(Context ctx, String fullName) {
        return this.getDataLoader(ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
    }

    @Override
    protected IDataProvider getMetaExecutor(Context ctx, String fullName) {
        return EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)fullName));
    }

    public void collectLinkageFormInfo(QingContext qingContext, LinkageContext linkageContext, List<AbstractEntity> entityList) {
        try {
            for (AbstractEntity entity : entityList) {
                LinkageFormInfo linkageFormInfo = LinkageFormInfoHelper.collectLinkageFormInfo(entity, LinkageFormInfoHelper.LinkageTypeEnum.SUBJECT);
                if (null == linkageFormInfo) continue;
                linkageContext.addLinkageFormInfo(entity.getName(), linkageFormInfo);
            }
        }
        catch (RuntimeException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }
}

